import React, { ComponentProps } from 'react';
import { Story } from '@storybook/react';
import { Pill } from './Pill';

export default {
    title: 'Components/Pill',
    component: Pill,
    argTypes: {},
};

/* Stories */

const Template: Story<ComponentProps<typeof Pill>> = (args) => {
    return (
        <div style={{ display: 'flex', gap: '0.5rem' }}>
            <Pill {...args} color={'primary'} />
            <Pill {...args} color={'success'} />
            <Pill {...args} color={'error'} />
            <Pill {...args} color={'warning'} />
            <Pill {...args} color={'grey'} />
        </div>
    );
};

//Default
export const Default = Template.bind({});

Default.args = {
    children: 'Children',
    onClose: () => {
        console.log('Closing Pill');
    },
};
