import { ComponentProps } from 'react';
import { Story, Meta } from '@storybook/react';

import { Button } from '../Button';
import { Popover } from './';

export default {
    title: 'Components/Popover',
    component: Popover,
    subcomponents: {
        Trigger: Popover.Trigger,
        Content: Popover.Content,
    },
    parameters: {
        layout: 'centered',
    },
} as Meta;

/* Stories */
const Template: Story<ComponentProps<typeof Popover>> = (args) => {
    return (
        <Popover {...args}>
            <Popover.Trigger>
                <Button variant="filled">Open Popover</Button>
            </Popover.Trigger>
            <Popover.Content side="top">Popover Content</Popover.Content>
        </Popover>
    );
};

// Default
export const Default = Template.bind({});
Default.args = {};
