import { ReactNode } from 'react';
import { Root } from '@radix-ui/react-popover';

export interface PopoverProps {
    /** Popover Trigger and Content */
    children: ReactNode;

    /** Boolean to control the state of the popover */
    open?: boolean;

    /** Callback that is triggered when the popover is opened */
    onOpen?: () => void;

    /** Callback that is triggered when the popover is closed */
    onClose?: () => void;
}

/**
 * Popover component
 */
export const Popover = (props: PopoverProps): JSX.Element => {
    const { children, open, onOpen = () => null, onClose = () => null } = props;

    return (
        <Root
            open={open}
            onOpenChange={(open) => {
                if (open) {
                    onOpen();
                } else {
                    onClose();
                }
            }}
        >
            {children}
        </Root>
    );
};
