import { useState, ComponentProps } from 'react';
import { Story } from '@storybook/react';

import { Portal } from './Portal';
import { Button } from '../Button';

export default {
    title: 'Components/Portal',
    component: Portal,
    argTypes: {},
};

/* Stories */
const Template: Story<ComponentProps<typeof Portal>> = (args) => {
    const [visible, setVisible] = useState(false);
    const [container, setContainer] = useState(null);
    return (
        <>
            <Button onClick={() => setVisible(!visible)}>Render Element</Button>
            <div>
                Content:
                <Portal container={container} {...args}>
                    {visible ? <span>Child Element</span> : null}
                </Portal>
            </div>

            <div ref={setContainer}> Portal: </div>
        </>
    );
};

// Default
export const Default = Template.bind({});
Default.args = {};
