import { ComponentProps, useState, useEffect } from 'react';
import { Story, Meta } from '@storybook/react';

import { Radio } from './';

export default {
    title: 'Components/Radio',
    component: Radio,
    subcomponents: {
        Item: Radio.Item,
    },
} as Meta;

/* Stories */

const Template: Story<ComponentProps<typeof Radio>> = (args) => {
    const { value, children, onChange, ...otherArgs } = args;

    const [activeValue, setActiveValue] = useState(value);

    useEffect(() => {
        setActiveValue(value);
    }, [value]);

    return (
        <>
            <Radio
                value={activeValue}
                onChange={(value) => {
                    setActiveValue(value);
                    onChange(value);
                }}
                {...otherArgs}
            >
                <Radio.Item value="radio 1">
                    {children ? children : 'Radio 1'}
                </Radio.Item>
                <Radio.Item value="radio 2">
                    {children ? children : 'Radio 2'}
                </Radio.Item>
                <Radio.Item value="radio 3">
                    {children ? children : 'Radio 3'}
                </Radio.Item>
                <Radio.Item value="radio 4" disabled={true}>
                    Disabled
                </Radio.Item>
                <Radio.Item value="radio 4" valid={false}>
                    Invalid
                </Radio.Item>
            </Radio>
        </>
    );
};

export const Default = Template.bind({});

Default.args = {
    value: '', // default to no selection
    disabled: false,
};

export const Selected = Template.bind({});

Selected.args = {
    ...Default.args,
    value: 'radio 1',
};

export const MultiLine = Template.bind({});

MultiLine.args = {
    ...Default.args,
    children: 'Multi-line content '.repeat(8),
};
