import React, { ComponentProps, useState, useEffect } from 'react';
import { Story } from '@storybook/react';
import { Select } from './';

export default {
    title: 'Components/Select',
    component: Select,
    argTypes: {},
};

/* Stories */

const Template: Story<ComponentProps<typeof Select>> = (args) => {
    const { value, onChange, ...otherArgs } = args;
    const [selectedValue, setSelectedValue] = useState(value);

    useEffect(() => {
        setSelectedValue(value);
    }, [value]);

    return (
        <Select
            value={selectedValue}
            onChange={(newValue) => {
                setSelectedValue(newValue);
                onChange(newValue);
            }}
            {...otherArgs}
        />
    );
};

// Default
export const Default = Template.bind({});

const options = [
    'Option A LONG Option A LONG Option A LONG Option A LONG',
    'Option B',
    'Option C',
    'Option AA',
    'Option BB',
    'Option CC',
];

Default.args = {
    value: null,
    label: 'Hello',
    options,
    disabled: false,
    placeholder: 'Select option',
};

export const Multiselect = Template.bind({});

Multiselect.args = {
    ...Default.args,
    multiple: true,
    value: [],
};

export const Disabled = Template.bind({});

Disabled.args = {
    ...Default.args,
    disabled: true,
};

export const Error = Template.bind({});

Error.args = {
    ...Default.args,
    valid: false,
};
