import { ComponentProps, useState, useEffect } from 'react';
import { Story } from '@storybook/react';
import { Slider } from './Slider';

export default {
    title: 'Components/Slider',
    component: Slider,
    argTypes: {},
};

/* Stories */

const Template: Story<ComponentProps<typeof Slider>> = (args) => {
    const { value, onChange, ...otherArgs } = args;

    const [activeValue, setActiveValue] = useState<number | [number, number]>(
        value,
    );

    useEffect(() => {
        setActiveValue(value);
    }, [value]);

    return (
        <Slider
            value={activeValue}
            onChange={(value) => {
                setActiveValue(value);
                onChange(value);
            }}
            {...otherArgs}
        />
    );
};

// Default
export const Default = Template.bind({});

Default.args = {
    id: 'Slider-Example',
    value: 50,
    disabled: false,
    multiple: false,
    min: 0,
    max: 100,
    step: 1,
};

// Default
export const Multiple = Template.bind({});

Multiple.args = {
    ...Default.args,
    multiple: true,
    value: [20, 80],
};

export const Disabled = Template.bind({});

Disabled.args = {
    ...Default.args,
    disabled: true,
};

export const DisabledMultiple = Template.bind({});

DisabledMultiple.args = {
    ...Multiple.args,
    disabled: true,
};

export const Error = Template.bind({});

Error.args = {
    ...Default.args,
    valid: false,
};

export const ErrorMultiple = Template.bind({});

ErrorMultiple.args = {
    ...Multiple.args,
    valid: false,
};
