import { ComponentProps } from 'react';
import { Story } from '@storybook/react';

import { Stepper } from '.';

export default {
    title: 'Components/Stepper',
    component: Stepper,
    subcomponents: {
        Stepper: Stepper,
        Step: Stepper.Step,
    },
};

/* Stories */
const Template: Story<ComponentProps<typeof Stepper>> = (args) => {
    return (
        <Stepper {...args}>
            <Stepper.Step value="1">Step 1</Stepper.Step>
            <Stepper.Step value="2" disabled={true}>
                Step 2
            </Stepper.Step>
            <Stepper.Step value="3" valid={false}>
                Step 3
            </Stepper.Step>
            <Stepper.Step value="4">Step 4</Stepper.Step>
        </Stepper>
    );
};

// Default
export const Default = Template.bind({});

Default.args = {};

// Horizontal
export const Horizontal = Template.bind({});

Horizontal.args = {
    layout: 'horizontal',
};
