import { ComponentProps, useState, useEffect } from 'react';
import { Story } from '@storybook/react';
import { Tabs } from '.';
import { styled } from '../../stitches.config';

const StyledDiv = styled('div', {
    padding: '16px',
});

export default {
    title: 'Components/Tabs',
    component: Tabs,
    subcomponents: {
        Tabslist: Tabs.List,
        Tabs: Tabs.Trigger,
        Content: Tabs.Content,
    },
};

/* Stories */

const Template: Story<ComponentProps<typeof Tabs>> = (args) => {
    const { value, onChange, ...otherArgs } = args;

    const [selectedTabs, setSelectedTabs] = useState(args.value);

    useEffect(() => {
        setSelectedTabs(value);
    }, [value]);

    return (
        <Tabs
            value={selectedTabs}
            onChange={(newValue) => {
                setSelectedTabs(newValue);
                onChange(newValue);
            }}
            {...otherArgs}
        >
            <Tabs.List>
                <Tabs.Trigger value={'value-1'}>Tabs 1</Tabs.Trigger>
                <Tabs.Trigger value={'value-2'}>Tabs 2</Tabs.Trigger>
                <Tabs.Trigger disabled={true} value={'value-3'}>
                    Tabs 3
                </Tabs.Trigger>
            </Tabs.List>
            <Tabs.Content value={'value-1'}>
                <StyledDiv>Content for Value 1</StyledDiv>
            </Tabs.Content>
            <Tabs.Content value={'value-2'}>
                <StyledDiv>Content for Value 2</StyledDiv>
            </Tabs.Content>
            <Tabs.Content value={'value-3'}>
                <StyledDiv>Content for Value 1</StyledDiv>
            </Tabs.Content>
        </Tabs>
    );
};

// Default
export const Default = Template.bind({});

Default.args = {
    value: 'value-2',
};
