import { ComponentPropsWithRef, forwardRef, ForwardedRef } from 'react';
import { Root } from '@radix-ui/react-tabs';

export interface TabsProps
    extends Omit<
        ComponentPropsWithRef<'div'>,
        'onChange' | 'defaultValue' | 'dir'
    > {
    /** Value of the tabs */
    value: string;

    /** Callback that is triggered when the value changes */
    onChange?: (value: string) => void;

    /** Mark the tabs in a disabled/enabled state */
    disabled?: boolean;
}

const _Tabs = (
    props: TabsProps,
    ref: ForwardedRef<HTMLDivElement>,
): JSX.Element => {
    const { value, onChange = () => null, children, ...otherProps } = props;

    return (
        <Root
            ref={ref}
            value={value}
            onValueChange={(v) => onChange(v)}
            {...otherProps}
        >
            {children}
        </Root>
    );
};

export const Tabs = forwardRef(_Tabs) as (
    props: TabsProps & {
        ref?: ForwardedRef<HTMLDivElement>;
    },
) => ReturnType<typeof _Tabs>;
