import { ComponentPropsWithRef, forwardRef, ForwardedRef } from 'react';

import { Content } from '@radix-ui/react-tabs';

export interface TabsContentProps extends ComponentPropsWithRef<'div'> {
    /** Value of the content */
    value: string;
}

const _TabsContent = (
    props: TabsContentProps,
    ref: ForwardedRef<HTMLDivElement>,
) => {
    const { value, children, ...otherProps } = props;
    return (
        <Content ref={ref} value={value} {...otherProps}>
            {children}
        </Content>
    );
};

export const TabsContent = forwardRef(_TabsContent) as (
    props: TabsContentProps & {
        ref?: ForwardedRef<HTMLDivElement>;
    },
) => ReturnType<typeof _TabsContent>;
