import { ComponentProps } from 'react';
import { Story, Meta } from '@storybook/react';

import { Button } from '../Button';
import { Tooltip } from './';

export default {
    title: 'Components/Tooltip',
    component: Tooltip,
    parameters: {
        layout: 'centered',
    },
} as Meta;

/* Stories */
const Template: Story<ComponentProps<typeof Tooltip>> = (args) => {
    return (
        <Tooltip {...args}>
            <Button variant="filled">Button</Button>
        </Tooltip>
    );
};

// Default
export const Default = Template.bind({});
Default.args = {
    content: 'Tooltip Content',
};
