import { ComponentProps, useState, useEffect } from 'react';
import { Story } from '@storybook/react';
import { Typeahead } from './';

export default {
    title: 'Components/Typeahead',
    component: Typeahead,
};

/* Stories */

const Template: Story<ComponentProps<typeof Typeahead>> = (args) => {
    const { value, onChange, ...otherArgs } = args;
    const [selectedValue, setSelectedValue] = useState(value);

    useEffect(() => {
        setSelectedValue(value);
    }, [value]);

    return (
        <Typeahead
            value={selectedValue}
            onChange={(newValue) => {
                setSelectedValue(newValue);
                onChange(newValue);
            }}
            {...otherArgs}
        />
    );
};

export const Default = Template.bind({});

const options = ['Ty', 'Type', 'Typeah', 'Typeahe', 'Typeahea', 'Typeahead'];

Default.args = {
    placeholder: 'Placeholder',
    options: options,
    value: '',
};

export const MultiTypehead = Template.bind({});

MultiTypehead.args = {
    ...Default.args,
    multiple: true,
    value: [],
};

export const Disabled = Template.bind({});

Disabled.args = {
    ...Default.args,
    disabled: true,
};

export const Error = Template.bind({});

Error.args = {
    ...Default.args,
    valid: false,
};
