import { styled } from '../../stitches.config';

import { InputOptions } from '../../utility';

export type BaseIconProps = Partial<Pick<InputOptions<unknown>, 'valid'>>;

export const BaseIcon = styled('div', {
    alignItems: 'center',
    color: '$grey-2',
    fontSize: '$space$5',
    display: 'inline-flex',
    variants: {
        valid: {
            true: {
                '&[data-expanded]': {
                    color: '$primary-1',
                },
            },
            false: {
                '&[data-expanded]': {
                    color: '$error-1',
                },
            },
        },
    },
    defaultVariants: {
        valid: true,
    },
});
