import { Dimensions, XYPosition, CoordinateExtent, Box, Rect } from '../types';
export declare const getDimensions: (node: HTMLDivElement) => Dimensions;
export declare const clamp: (val: number, min?: number, max?: number) => number;
export declare const clampPosition: (position: XYPosition, extent: CoordinateExtent) => {
    x: number;
    y: number;
};
export declare const getHostForElement: (element: HTMLElement) => Document | ShadowRoot;
export declare const getBoundsOfBoxes: (box1: Box, box2: Box) => Box;
export declare const rectToBox: ({ x, y, width, height }: Rect) => Box;
export declare const boxToRect: ({ x, y, x2, y2 }: Box) => Rect;
export declare const getBoundsofRects: (rect1: Rect, rect2: Rect) => Rect;
export declare const isNumeric: (n: any) => n is number;
export declare const internalsSymbol: unique symbol;
