/* eslint-disable one-var */
const hostName = {
        display: 'Host Name',
        description: '',
        required: true,
        defaultValue: '',
        type: 'text',
        advanced: false,
        alias: 'hostname',
    },
    port = {
        display: 'Port',
        description: '',
        required: false,
        defaultValue: '',
        type: 'text',
        advanced: false,
        alias: 'port',
    },
    database = {
        display: 'Database',
        description: '',
        required: true,
        defaultValue: '',
        type: 'text',
        advanced: false,
        alias: 'database',
    },
    schema = {
        display: 'Schema',
        description: '',
        required: true,
        defaultValue: '',
        type: 'text',
        advanced: false,
        alias: 'schema',
    },
    username = {
        display: 'Username',
        description: '',
        required: false,
        defaultValue: '',
        type: 'text',
        advanced: false,
        alias: 'USERNAME',
    },
    password = {
        display: 'Password',
        description: '',
        required: false,
        defaultValue: '',
        secret: true,
        type: 'text',
        advanced: false,
        alias: 'PASSWORD',
    },
    fetchSize = {
        display: 'Fetch Size',
        description: '',
        required: false,
        defaultValue: '',
        type: 'number',
        advanced: true,
        alias: 'FETCH_SIZE',
    },
    connectionQueryTimeout = {
        display: 'Connection Query Timeout',
        description: '',
        required: false,
        defaultValue: '',
        type: 'number',
        advanced: true,
        alias: 'CONNECTION_QUERY_TIMEOUT',
    },
    useConnectionPooling = {
        display: 'Use Connection Pooling',
        description: '',
        required: false,
        defaultValue: false,
        type: 'boolean',
        advanced: true,
        alias: 'USE_CONNECTION_POOLING',
    },
    poolMinSize = {
        display: 'Pool Minimum Size',
        description: '',
        required: false,
        defaultValue: '',
        type: 'number',
        advanced: true,
        alias: 'POOL_MIN_SIZE',
    },
    poolMaxSize = {
        display: 'Pool Maximum Size',
        description: '',
        required: false,
        defaultValue: '',
        type: 'number',
        advanced: true,
        alias: 'POOL_MAX_SIZE',
    };

const CONNECTORS = {
    ASTER_DB: {
        name: 'Aster',
        driver: 'ASTER_DB',
        type: 'RDBMS',
        image: require('@/assets/img/ASTER.png'),
        url: 'jdbc:ncluster://<hostname>:<port>/<schema>',
        inputs: [hostName, port, schema, username, password],
        advancedInputs: [
            fetchSize,
            connectionQueryTimeout,
            useConnectionPooling,
            poolMinSize,
            poolMaxSize,
        ],
    },
    ATHENA: {
        name: 'Athena',
        driver: 'ATHENA',
        type: 'RDBMS',
        image: require('@/assets/img/ATHENA.png'),
        url: 'jdbc:awsathena://AwsRegion=<region>;User=<accessKey>;Password=<secretKey>;S3OutputLocation=<output>;Schema=<schema>',
        inputs: [
            {
                display: 'Region',
                description: '',
                required: true,
                defaultValue: '',
                alias: 'region',
            },
            {
                display: 'Access Key',
                description: '',
                required: true,
                defaultValue: '',
                alias: 'accessKey',
            },
            {
                display: 'Secret Key',
                description: '',
                required: true,
                defaultValue: '',
                secret: true,
                alias: 'secretKey',
            },
            {
                display: 'Output',
                description:
                    'S3 bucket location where query outputs are written. User must have write access.',
                required: true,
                defaultValue: '',
                alias: 'output',
            },
            {
                display: 'Schema',
                description: '',
                required: false,
                defaultValue: 'default',
                alias: 'schema',
            },
        ],
        advancedInputs: [
            fetchSize,
            connectionQueryTimeout,
            useConnectionPooling,
            poolMinSize,
            poolMaxSize,
        ],
    },
    BIG_QUERY: {
        name: 'BigQuery',
        driver: 'BIG_QUERY',
        type: 'RDBMS',
        image: require('@/assets/img/BIGQUERY.png'),
        url: 'jdbc:bigquery://<hostname>:<port>;ProjectId=<projectId>;DefaultDataset=<schema>;OAuthType=<oauthType>;OAuthServiceAcctEmail=<oauthServiceAcctEmail>;OAuthPvtKeyPath=<oauthPvtKeyPath>',
        inputs: [
            {
                display: 'Hostname',
                description: '',
                required: true,
                defaultValue: 'https://www.googleapis.com/bigquery/v2',
                alias: 'hostname',
            },
            {
                display: 'Port',
                description: '',
                required: false,
                defaultValue: '443',
                alias: 'port',
            },
            {
                display: 'Project',
                required: true,
                description: '',
                defaultValue: '',
                alias: 'projectId',
            },
            schema,
            {
                display: 'OAuthType',
                required: true,
                description:
                    'Currently, only service account and service key file is supported',
                defaultValue: '0',
                alias: 'oauthType',
            },
            {
                display: 'OAuth Service Account',
                required: false,
                description: '',
                defaultValue: '',
                alias: 'oauthServiceAcctEmail',
            },
            {
                display: 'OAuth Private Account Key Path',
                required: false,
                description: '',
                defaultValue: '',
                alias: 'oauthPvtKeyPath',
            },
        ],
    },
    CASSANDRA: {
        name: 'Cassandra',
        driver: 'CASSANDRA',
        type: 'RDBMS',
        image: require('@/assets/img/CASSANDRA.png'),
        url: 'jdbc:cassandra://<hostname>:<port>/<schema>',
        inputs: [
            hostName,
            {
                display: 'Port',
                description: '',
                required: false,
                defaultValue: '9042',
                alias: 'port',
            },
            schema,
            username,
            password,
        ],
        advancedInputs: [
            fetchSize,
            connectionQueryTimeout,
            useConnectionPooling,
            poolMinSize,
            poolMaxSize,
        ],
    },
    DATASTAX: {
        name: 'DataStax',
        driver: 'DATASTAX',
        type: 'GRAPH',
        image: require('@/assets/img/DATASTAX.png'),
        url: '',
        inputs: [],
        advancedInputs: [],
    },
    DB2: {
        name: 'DB2',
        driver: 'DB2',
        type: 'RDBMS',
        image: require('@/assets/img/DB2.png'),
        url: 'jdbc:db2://<hostname>:<port>/<schema>',
        inputs: [
            hostName,
            {
                display: 'Port',
                description: '',
                required: false,
                defaultValue: '446',
                alias: 'port',
            },
            schema,
            username,
            password,
        ],
        advancedInputs: [
            fetchSize,
            connectionQueryTimeout,
            useConnectionPooling,
            poolMinSize,
            poolMaxSize,
        ],
    },
    DERBY: {
        name: 'Derby',
        driver: 'DERBY',
        type: 'RDBMS',
        image: require('@/assets/img/DERBY.png'),
        url: 'jdbc:derby://<hostname>:<port>/<schema>',
        inputs: [
            hostName,
            {
                display: 'Port',
                description: '',
                required: false,
                defaultValue: '1527',
                alias: 'port',
            },
            schema,
            username,
            password,
        ],
        advancedInputs: [
            fetchSize,
            connectionQueryTimeout,
            useConnectionPooling,
            poolMinSize,
            poolMaxSize,
        ],
    },
    ELASTIC_SEARCH: {
        name: 'Elastic Search',
        driver: 'ELASTIC_SEARCH',
        type: 'RDBMS',
        image: require('@/assets/img/ELASTIC_SEARCH.svg'),
        url: 'jdbc:es://<httpType>://<hostname>:<port>',
        inputs: [
            hostName,
            {
                display: 'Port',
                description: '',
                required: false,
                defaultValue: '9200',
                alias: 'port',
            },
            {
                display: 'Http Type',
                description: 'Either https or http',
                required: false,
                defaultValue: 'https',
                alias: 'httpType',
            },
            username,
            password,
        ],
    },
    H2_DB: {
        name: 'H2',
        driver: 'H2_DB',
        type: 'RDBMS',
        image: require('@/assets/img/H2_DB.png'),
        url: 'jdbc:h2:tcp://<hostname>:<port>/<schema>',
        inputs: [
            hostName,
            {
                display: 'Port',
                description: '',
                required: false,
                defaultValue: '8082',
                alias: 'port',
            },
            schema,
            username,
            password,
        ],
        advancedInputs: [
            fetchSize,
            connectionQueryTimeout,
            useConnectionPooling,
            poolMinSize,
            poolMaxSize,
        ],
    },
    HIVE: {
        name: 'Hive',
        driver: 'HIVE',
        type: 'RDBMS',
        image: require('@/assets/img/HIVE.jpg'),
        url: 'jdbc:hive://<hostname>:<port>/<schema>',
        inputs: [
            hostName,
            {
                display: 'Port',
                description: '',
                required: false,
                defaultValue: '10000',
                alias: 'port',
            },
            schema,
            username,
            password,
        ],
        advancedInputs: [
            fetchSize,
            connectionQueryTimeout,
            useConnectionPooling,
            poolMinSize,
            poolMaxSize,
        ],
    },
    IMPALA: {
        name: 'Impala',
        driver: 'IMPALA',
        type: 'RDBMS',
        image: require('@/assets/img/IMPALA.png'),
        url: 'jdbc:impala://<hostname>:<port>/<schema>',
        inputs: [
            hostName,
            {
                display: 'Port',
                description: '',
                required: false,
                defaultValue: '21050',
                alias: 'port',
            },
            schema,
            username,
            password,
        ],
        advancedInputs: [
            fetchSize,
            connectionQueryTimeout,
            useConnectionPooling,
            poolMinSize,
            poolMaxSize,
        ],
    },
    MARIA_DB: {
        name: 'MariaDB',
        driver: 'MARIA_DB',
        type: 'RDBMS',
        image: require('@/assets/img/MARIA_DB.png'),
        url: 'jdbc:mariadb://<hostname>:<port>/<schema>',
        inputs: [
            hostName,
            {
                display: 'Port',
                description: '',
                required: false,
                defaultValue: '3306',
                alias: 'port',
            },
            schema,
            username,
            password,
        ],
        advancedInputs: [
            fetchSize,
            connectionQueryTimeout,
            useConnectionPooling,
            poolMinSize,
            poolMaxSize,
        ],
    },
    MYSQL: {
        name: 'MySQL',
        driver: 'MYSQL',
        type: 'RDBMS',
        image: require('@/assets/img/MYSQL.png'),
        url: 'jdbc:mysql://<hostname>:<port>/<schema>?user=<USERNAME>&password=<PASSWORD>',
        inputs: [
            hostName,
            {
                display: 'Port',
                description: '',
                required: false,
                defaultValue: '3306',
                alias: 'port',
            },
            schema,
            username,
            password,
        ],
        advancedInputs: [
            fetchSize,
            connectionQueryTimeout,
            useConnectionPooling,
            poolMinSize,
            poolMaxSize,
        ],
    },
    OPEN_SEARCH: {
        name: 'Open Search',
        driver: 'OPEN_SEARCH',
        type: 'RDBMS',
        image: require('@/assets/img/OPEN_SEARCH.png'),
        url: 'jdbc:opensearch://<httpType>://<hostname>:<port>',
        inputs: [
            hostName,
            {
                display: 'Port',
                description: '',
                required: false,
                defaultValue: '9200',
                alias: 'port',
            },
            {
                display: 'Http Type',
                description: 'Either https or http',
                required: false,
                defaultValue: 'https',
                alias: 'httpType',
            },
            username,
            password,
        ],
    },
    ORACLE: {
        name: 'Oracle',
        driver: 'ORACLE',
        type: 'RDBMS',
        image: require('@/assets/img/ORACLE.png'),
        url: 'jdbc:oracle:thin:@<hostname>:<port>:<service>',
        inputs: [
            hostName,
            port,
            {
                display: 'SID/Service',
                required: true,
                description: '',
                defaultValue: '1521',
                alias: 'service',
            },
            username,
            password,
        ],
        advancedInputs: [
            fetchSize,
            connectionQueryTimeout,
            useConnectionPooling,
            poolMinSize,
            poolMaxSize,
        ],
    },
    PHOENIX: {
        name: 'Phoenix',
        driver: 'PHOENIX',
        type: 'RDBMS',
        image: require('@/assets/img/PHOENIX.png'),
        url: 'jdbc:phoenix://<hostname>:<port>/<schema>',
        inputs: [
            hostName,
            {
                display: 'Port',
                description: '',
                required: false,
                defaultValue: '8765',
                alias: 'port',
            },
            schema,
            username,
            password,
        ],
        advancedInputs: [
            fetchSize,
            connectionQueryTimeout,
            useConnectionPooling,
            poolMinSize,
            poolMaxSize,
        ],
    },
    POSTGRES: {
        name: 'Postgres',
        driver: 'POSTGRES',
        type: 'RDBMS',
        image: require('@/assets/img/POSTGRES.png'),
        url: 'jdbc:postgresql://<hostname>:<port>/<schema>',
        inputs: [
            hostName,
            {
                display: 'Port',
                description: '',
                required: false,
                defaultValue: '5432',
                alias: 'port',
            },
            database,
            schema,
            username,
            password,
        ],
        advancedInputs: [
            fetchSize,
            connectionQueryTimeout,
            useConnectionPooling,
            poolMinSize,
            poolMaxSize,
        ],
    },
    REDSHIFT: {
        name: 'Redshift',
        driver: 'REDSHIFT',
        type: 'RDBMS',
        image: require('@/assets/img/REDSHIFT.png'),
        url: 'jdbc:redshift://<hostname>:<port>/<schema>',
        inputs: [
            hostName,
            {
                display: 'Port',
                description: '',
                required: false,
                defaultValue: '5439',
                alias: 'port',
            },
            database,
            schema,
            username,
            password,
        ],
        advancedInputs: [
            fetchSize,
            connectionQueryTimeout,
            useConnectionPooling,
            poolMinSize,
            poolMaxSize,
        ],
    },
    SAP_HANA: {
        name: 'SAP Hana',
        driver: 'SAP_HANA',
        type: 'RDBMS',
        image: require('@/assets/img/SAP_HANA.png'),
        url: 'jdbc:sap://<hostname>:<port>/?currentSchema=<schema>',
        inputs: [
            hostName,
            {
                display: 'Port',
                description: '',
                required: false,
                defaultValue: '30015',
                alias: 'port',
            },
            schema,
            username,
            password,
        ],
        advancedInputs: [
            fetchSize,
            connectionQueryTimeout,
            useConnectionPooling,
            poolMinSize,
            poolMaxSize,
        ],
    },
    SNOWFLAKE: {
        name: 'Snowflake',
        driver: 'SNOWFLAKE',
        type: 'RDBMS',
        image: require('@/assets/img/SNOWFLAKE.png'),
        url: 'jdbc:snowflake://<hostname>:<port>/?warehouse=<warehouse>&role=<role>&db=<database>&schema=<schema>',
        inputs: [
            hostName,
            {
                display: 'Port',
                description: '',
                required: false,
                defaultValue: '443',
                alias: 'port',
            },
            {
                display: 'Warehouse',
                required: true,
                description: '',
                defaultValue: '',
                alias: 'warehouse',
            },
            {
                display: 'Role',
                required: true,
                description: '',
                defaultValue: 'PUBLIC',
                alias: 'role',
            },
            database,
            schema,
            username,
            password,
        ],
        advancedInputs: [
            fetchSize,
            connectionQueryTimeout,
            useConnectionPooling,
            poolMinSize,
            poolMaxSize,
        ],
    },
    SQL_SERVER: {
        name: 'SQL Server',
        driver: 'SQL_SERVER',
        type: 'RDBMS',
        image: require('@/assets/img/SQL_SERVER.png'),
        url: 'jdbc:sqlserver://<hostname>:<port>;databaseName=<schema>;user=<USERNAME>;password=<PASSWORD>;selectMethod=cursor',
        inputs: [
            hostName,
            {
                display: 'Port',
                description: '',
                required: false,
                defaultValue: '1433',
                alias: 'port',
            },
            database,
            {
                display: 'Schema',
                description: '',
                required: false,
                defaultValue: 'dbo',
                alias: 'schema',
            },
            username,
            password,
        ],
        advancedInputs: [
            fetchSize,
            connectionQueryTimeout,
            useConnectionPooling,
            poolMinSize,
            poolMaxSize,
        ],
    },
    SQLITE: {
        name: 'SQLITE',
        driver: 'SQLITE',
        type: 'RDBMS',
        image: require('@/assets/img/SQLITE.png'),
        url: 'jdbc:sqlite://<hostname>:<port>',
        inputs: [hostName, port, username, password],
        advancedInputs: [
            fetchSize,
            connectionQueryTimeout,
            useConnectionPooling,
            poolMinSize,
            poolMaxSize,
        ],
    },
    TERADATA: {
        name: 'Teradata',
        driver: 'TERADATA',
        type: 'RDBMS',
        image: require('@/assets/img/TERADATA.png'),
        url: 'jdbc:teradata://<hostname>/Database=<database>',
        inputs: [hostName, database, username, password],
        advancedInputs: [
            fetchSize,
            connectionQueryTimeout,
            useConnectionPooling,
            poolMinSize,
            poolMaxSize,
        ],
    },
    TIBCO: {
        name: 'Tibco',
        driver: 'TIBCO',
        type: 'RDBMS',
        image: require('@/assets/img/TIBCO.png'),
        url: 'jdbc:compositesw:dbapi@<hostname>:<port>?<schema>',
        inputs: [
            hostName,
            {
                display: 'Port',
                description: '',
                required: false,
                defaultValue: '1433',
                alias: 'port',
            },
            schema,
            username,
            password,
        ],
        advancedInputs: [
            fetchSize,
            connectionQueryTimeout,
            useConnectionPooling,
            poolMinSize,
            poolMaxSize,
        ],
    },
    TRINO: {
        name: 'Trino',
        driver: 'TRINO',
        type: 'RDBMS',
        image: require('@/assets/img/TRINO.jpg'),
        url: 'jdbc:trino://<hostname>:<catalog>/<database>/<schema>',
        inputs: [
            hostName,
            port,
            {
                display: 'Catalog',
                description: '',
                required: true,
                defaultValue: '',
                alias: 'catalog',
            },
            schema,
            username,
            password,
        ],
        advancedInputs: [
            fetchSize,
            connectionQueryTimeout,
            useConnectionPooling,
            poolMinSize,
            poolMaxSize,
        ],
    },
};

const GRAPH_TYPES = [
    'JENA',
    'SESAME',
    'TINKER',
    'NEO4J',
    'NEO4J_EMBEDDED',
    'DATASTAX_GRAPH',
    'JANUS_GRAPH',
    'RDF',
];

const FILES = {
    csv: {
        name: 'CSV',
        fileType: 'csv',
        image: require('@/assets/img/CSV.svg'),
    },
    tsv: {
        name: 'TSV',
        fileType: 'tsv',
        image: require('@/assets/img/TSV.svg'),
    },
    excel: {
        name: 'Excel',
        fileType: 'excel',
        image: require('@/assets/img/EXCEL.png'),
    },
    paste: {
        name: 'Paste',
        fileType: 'paste',
        image: require('@/assets/img/PASTE.svg'),
    },
    txt: {
        name: 'Text',
        fileType: 'txt',
        image: require('@/assets/img/text-document.svg'),
    },
};

const SOCIAL = {
    dropbox: {
        name: 'Dropbox',
        provider: 'dropbox',
        image: require('@/assets/img/dropbox.png'),
    },
    google: {
        name: 'Google',
        provider: 'google',
        image: require('@/assets/img/google.png'),
    },
    ms: {
        name: 'Microsoft',
        provider: 'ms',
        image: require('@/assets/img/ms.png'),
    },
};

const PREVIEW_LIMIT = 20;

const WORKSHEET = {
    sheetId: '',
    labelOverride: false,
    sheetLabel: 'Sheet 0',
    contentEditable: 'false',
    backgroundColor: '',
    height: '100%',
    width: '100%',
    hideHeaders: false,
    hideGutters: false,
    gutterSize: 2,
    selected: {
        panels: '', // list of selected panels. Generally 1
        mode: 'move', // mode of the selected panels. Options are move, edit
    },
    panels: {}, // basic panel information
    golden: {}, // put the golden information
};

const PANEL_TYPES = {
    GOLDEN: 'golden',
    FLOATING: 'floating',
};

const PANEL_OPTIONS = {
    GOLDEN: {
        panelId: '',
        widgetId: '',
        sheetId: '',
        labelOverride: false,
        panelLabel: '',
        config: {
            type: 'golden',
            backgroundColor: '',
            panelstatus: 'normalized',
            opacity: 100,
            componentName: 'panel',
        },
    },
    FLOATING: {
        panelId: '',
        widgetId: '',
        sheetId: '',
        labelOverride: false,
        panelLabel: '',
        config: {
            type: 'floating',
            borderWidth: '',
            borderStyle: '',
            borderColor: '',
            backgroundColor: '',
            shadowX: '',
            shadowY: '',
            shadowBlur: '',
            shadowSpread: '',
            shadowColor: '',
            backgroundImage: '',
            backgroundOrigin: '',
            backgroundPosition: '',
            backgroundRepeat: '',
            backgroundSize: '',
            opacity: 100,
            panelstatus: 'normalized',
            top: '0%',
            left: '0%',
            height: '50%',
            width: '50%',
            zIndex: 0,
            // old
            subType: '',
        },
    },
};

const THEME = {
    themeName: 'Default',
    sheet: {
        backgroundColor: '#FFFFFF',
    },
    panel: {
        backgroundColor: '#FFFFFF',
        borderWidth: '1px',
        borderStyle: '',
        borderColor: '#C6CCD0',
        shadowX: '0px',
        shadowY: '0px',
        shadowBlur: '0px',
        shadowSpread: '0px',
        shadowColor: '',
    },
    color: {
        scheme: {
            colors: [
                '#40A0FF',
                '#9A74B6',
                '#FBB83A',
                '#51ACA8',
                '#F18630',
                '#187637',
                '#CD5498',
                '#D7D14A',
            ],
            colorName: 'Semoss',
        },
        iconDark: '#1E1E1E',
        iconLight: '#FFFEF9',
    },
    chart: {
        // colorRange: used by heatmap, choropleth, gauge
        colorRange: [
            '#40A0FF',
            '#5DAEFF',
            '#79BDFF',
            '#9FCFFF',
            '#C6E3FF',
            '#E2F1FF',
            '#F6E2EF',
            '#EDC5DF',
            '#E19DC9',
            '#D577B3',
            '#CC59A3',
            '#C33C93',
        ],
        // colorDuo: used by waterfall
        colorDuo: ['#3FA875', '#F84C34'],
        grid: {
            borderColor: '#C6CCD0',
            borderWidth: '1px',
        },
        axis: {
            borderColor: '#63666A',
            borderWidth: '1px',
            label: {
                fontColor: '#63666A',
                fontFamily: 'Inter',
                fontSize: '11px',
                fontWeight: '300',
            },
            name: {
                fontColor: '#63666A',
                fontFamily: 'Inter',
                fontSize: '11px',
                fontWeight: '400',
            },
            pointer: {
                lineStyle: {
                    lineColor: '#C6CCD0',
                    lineWidth: '2px',
                    lineType: 'dashed',
                    opacity: '.5',
                },
                shadowStyle: {
                    backgroundColor: '#C6CCD0',
                    opacity: '.2',
                },
            },
        },
        title: {
            fontColor: '#63666A',
            fontFamily: 'Inter',
            fontSize: '18px',
            fontWeight: '600',
        },
        value: {
            fontColor: '#63666A',
            fontColorAlt: '#ffffff', // Used by: Bubble, Funnel, Half Donut, Sunburst
            fontFamily: 'Inter',
            fontSize: '12px',
            fontWeight: '400',
        },
        legend: {
            fontColor: '#5C5C5C',
            fontFamily: 'Inter',
            fontSize: '12px',
            fontWeight: '300',
            align: 'left-top',
            backgroundColor: '#FFFFFF',
            leftalign: 'left',
            orient: 'vertical',
            topalign: 'top',
        },
        tooltip: {
            backgroundColor: '#FFFFFF',
            borderWidth: '1px',
            borderColor: 'transparent',
            fontFamily: 'Inter',
            fontColor: '#63666A',
            fontSize: '14px',
        },
        dataZoom: {
            backgroundColor: '#F8F8F8',
            fillerColor: 'rgba(205, 84, 152, 0.2)',
            borderColor: '#8E8E8E',
            dataBackground: {
                lineStyle: {
                    lineColor: '#40A0FF',
                    lineWidth: '1px',
                    lineStyle: 'solid',
                },
                areaStyle: {
                    backgroundColor: '#40A0FF',
                    opacity: '0.1',
                },
            },
            selectedDataBackground: {
                lineStyle: {
                    lineColor: '#9A74B6',
                    lineWidth: '1px',
                    lineStyle: 'solid',
                },
                areaStyle: {
                    backgroundColor: '#9A74B6',
                    opacity: '0.2',
                },
            },
            handle: {
                backgroundColor: '#FFFFFF',
                borderWidth: '.5px',
                borderStyle: 'solid',
                borderColor: '#CD5498',
            },
            moveHandle: {
                backgroundColor: '#CD5498',
                borderWidth: '.5px',
                borderStyle: 'solid',
                borderColor: '#CD5498',
            },
        },
        treemap: {
            heading: {
                backgroundColor: '#D9D9D9',
                fontColor: '#5C5C5C',
                fontFamily: 'Inter',
                fontSize: '12px',
                fontWeight: '500',
            },
            breadcrumb: {
                backgroundColor: '#D9D9D9',
                fontColor: '#5C5C5C',
                fontFamily: 'Inter',
                fontSize: '10px',
                fontWeight: '500',
                borderWidth: '0px',
                borderStyle: '',
                borderColor: '',
            },
        },
        boxwhisker: {
            borderWidth: '1px',
            borderStyle: 'solid',
            borderColor: '#1E1E1E',
        },
        graph: {
            lineWidth: '1px',
            lineStyle: 'solid',
            lineColor: '#C6CCD0',
        },
        dendrogram: {
            lineWidth: '1px',
            lineColor: '#C6CCD0',
        },
    },
    kpi: {
        value: {
            fontColor: '#40A0FF',
            fontFamily: 'Inter',
            fontSize: '40px',
            fontWeight: '400',
        },
        label: {
            fontColor: '#1E1E1E',
            fontFamily: 'Inter',
            fontSize: '14px',
            fontWeight: '500',
        },
    },
    filter: {
        backgroundColor: '#F5F5F5',
        borderWidth: '',
        borderStyle: '',
        borderColor: '',
        shadowX: '',
        shadowY: '',
        shadowBlur: '',
        shadowSpread: '',
        shadowColor: '',
        component: {
            '--color-primary-100': '#40A0FF',
            '--color-primary-70': '#79bdff',
            '--color-primary-50': '#9fcfff',
            '--color-primary-30': '#c6e3ff',
            '--color-primary-10': '#ecf6ff',
            '--color-grey-1': '#1e1e1e',
            '--color-grey-2': '#5c5c5c',
            '--color-grey-3': '#8e8e8e',
            '--color-grey-4': '#bdbdbd',
            '--color-grey-5': '#d9d9d9',
            '--color-grey-6': '#f6f6f6',
            '--color-white': '#FFFFFF',
            '--font-family': 'Inter',
        },
    },
    text: {
        backgroundColor: 'transparent',
        borderWidth: '',
        borderStyle: '',
        borderColor: '',
        shadowX: '',
        shadowY: '',
        shadowBlur: '',
        shadowSpread: '',
        shadowColor: '',
        title: {
            fontColor: '#000000',
            fontFamily: 'Inter',
            fontSize: '32px',
        },
        subtitle: {
            fontColor: '#000000',
            fontFamily: 'Inter',
            fontSize: '20px',
        },
        body: {
            fontColor: '#000000',
            fontFamily: 'Inter',
            fontSize: '14px',
        },
    },
};

const OPERATIONS = [
    {
        display: 'Average',
        alias: 'Average',
        function: 'Average',
        group: 'math',
        types: ['NUMBER'],
    },
    {
        display: 'Average (Unique)',
        alias: 'Unique_Average',
        function: 'UniqueAverage',
        group: 'math',
        types: ['NUMBER'],
    },
    {
        display: 'Count',
        function: 'Count',
        group: 'math',
        types: ['DATE', 'STRING', 'FACTOR', 'NUMBER'],
    },
    {
        display: 'Count (Unique)',
        alias: 'Unique_Count',
        function: 'UniqueCount',
        group: 'math',
        types: ['DATE', 'STRING', 'FACTOR', 'NUMBER'],
    },
    {
        display: 'Group Concat',
        alias: 'Group_Concat',
        function: 'GroupConcat',
        group: 'concat',
        types: ['DATE', 'STRING', 'FACTOR', 'NUMBER'],
    },
    {
        display: 'Group Concat (Unique)',
        alias: 'Unique_Group_Concat',
        function: 'UniqueGroupConcat',
        group: 'concat',
        types: ['DATE', 'STRING', 'FACTOR', 'NUMBER'],
    },
    {
        display: 'Max',
        alias: 'Max',
        function: 'Max',
        group: 'math',
        types: ['NUMBER'],
    },
    {
        display: 'Median',
        alias: 'Median',
        function: 'Median',
        group: 'math',
        types: ['NUMBER'],
    },
    {
        display: 'Min',
        alias: 'Min',
        function: 'Min',
        group: 'math',
        types: ['NUMBER'],
    },
    {
        display: 'Standard Deviation',
        alias: 'Standard_Deviation',
        function: 'StandardDeviation',
        group: 'math',
        types: ['NUMBER'],
    },
    {
        display: 'Sum',
        alias: 'Sum',
        function: 'Sum',
        group: 'math',
        types: ['NUMBER'],
    },
    {
        display: 'Sum (Unique)',
        alias: 'Unique_Sum',
        function: 'UniqueSum',
        group: 'math',
        types: ['NUMBER'],
    },
];

const COMPARATOR = [
    {
        display: 'Equal To',
        value: '==',
        types: [
            'NUMBER',
            'DOUBLE',
            'INT',
            'STRING',
            'FACTOR',
            'DATE',
            'TIMESTAMP',
            'BOOLEAN',
        ],
    },
    {
        display: 'Not Equal To',
        value: '!=',
        types: [
            'NUMBER',
            'DOUBLE',
            'INT',
            'STRING',
            'FACTOR',
            'DATE',
            'TIMESTAMP',
            'BOOLEAN',
        ],
    },
    {
        display: 'Contains',
        value: '?like',
        types: ['STRING', 'FACTOR'],
    },
    {
        display: 'Starts With',
        value: '?begins',
        types: ['STRING', 'FACTOR'],
    },
    {
        display: 'Ends With',
        value: '?ends',
        types: ['STRING', 'FACTOR'],
    },
    {
        display: 'Less Than',
        value: '<',
        types: ['NUMBER', 'DOUBLE', 'INT', 'DATE', 'TIMESTAMP'],
    },
    {
        display: 'Less Than or Equal To',
        value: '<=',
        types: ['NUMBER', 'DOUBLE', 'INT', 'DATE', 'TIMESTAMP'],
    },
    {
        display: 'Greater Than',
        value: '>',
        types: ['NUMBER', 'DOUBLE', 'INT', 'DATE', 'TIMESTAMP'],
    },
    {
        display: 'Greater Than or Equal To',
        value: '>=',
        types: ['NUMBER', 'DOUBLE', 'INT', 'DATE', 'TIMESTAMP'],
    },
];

const EXPRESSIONS = [
    {
        display: 'Add',
        expression: '+',
        types: ['NUMBER', 'DOUBLE', 'INT'],
    },
    {
        display: 'Subtract',
        expression: '-',
        types: ['NUMBER', 'DOUBLE', 'INT'],
    },
    {
        display: 'Multiply',
        expression: '*',
        types: ['NUMBER', 'DOUBLE', 'INT'],
    },
    {
        display: 'Divide',
        expression: '/',
        types: ['NUMBER', 'DOUBLE', 'INT'],
    },
];

const FONT_FAMILY = [
    {
        display: 'Arial',
        value: 'Arial, Helvetica, sans-serif',
    },
    {
        display: 'Arial Black',
        value: '"Arial Black", Gadget, sans-serif',
    },
    {
        display: 'Arial Narrow',
        value: '"Arial Narrow", Arial, sans-serif',
    },
    {
        display: 'Calibri',
        value: 'Calibri',
    },
    {
        display: 'Century Gothic',
        value: 'Century Gothic',
    },
    {
        display: 'Comic Sans MS',
        value: '"Comic Sans MS", cursive, sans-serif',
    },
    {
        display: 'Courier New',
        value: '"Courier New", Courier, monospace',
    },
    {
        display: 'Garamond',
        value: 'Garamond',
    },
    {
        display: 'Georgia',
        value: 'Georgia',
    },
    {
        display: 'Helvetica',
        value: 'Helvetica',
    },
    {
        display: 'Inter',
        value: 'Inter',
    },
    {
        display: 'Open Sans',
        value: 'Open Sans',
    },
    {
        display: 'Sans-Serif',
        value: 'sans-serif',
    },
    {
        display: 'Segoe UI',
        value: 'Segoe UI',
    },
    {
        display: 'Times New Roman',
        value: '"Times New Roman", Times, serif',
    },
    {
        display: 'Verdana',
        value: 'Verdana',
    },
];

export {
    CONNECTORS,
    GRAPH_TYPES,
    FILES,
    SOCIAL,
    PREVIEW_LIMIT,
    WORKSHEET,
    THEME,
    PANEL_TYPES,
    PANEL_OPTIONS,
    OPERATIONS,
    COMPARATOR,
    EXPRESSIONS,
    FONT_FAMILY,
};
