module.exports = {
    name: 'Gantt',
    icon: require('images/gantt.svg'),
    widgetList: {
        tags: ['Visualization'],
        showOn: 'none',
        hideHandles: [],
        quickMenu: [
            'events',
            'show-date',
            'gantt-group-view',
            'target-date',
            'target-date-range',
            'toggle-legend',
            'unfilter',
            'color-panel-mode',
            'color-by-value',
        ],
    },
    content: {
        template: {
            name: 'gantt',
        },
    },
    visualization: {
        type: ['standard', 'echarts'],
        group: 'Visualization',
        view: 'visualization',
        layout: 'GanttD3',
        visibleModes: ['default-mode', 'comment-mode'],
        tools: [
            'custom-legend',
            'filter',
            'unfilter',
            'color-panel',
            'color-by-value',
            'sort-values',
            'format-data-values',
            'show-date',
            'target-date',
            'target-date-range',
            'gantt-group-view',
            'display-values',
            'fiscal-axis',
            'toggle-legend',
            'toggle-tooltips',
            'reset-state',
            'events',
            'param',
            'purge',
            'refresh-cache',
            'customize-symbol',
            'chart-title',
        ],
        showOnVisualPanel: true,
        visualPanelMenu: {
            USE: 'Pipeline',
        },
        format: 'table',
        fields: [
            {
                model: 'task',
                name: 'Task',
                acceptableTypes: ['STRING', 'NUMBER'],
                group: 'validate',
                optional: false,
                multiField: false,
                description:
                    'Try adding one categorical dimension (i.e. Sprint Tasks). Each instance will represent a task (bar) in the gantt chart.',
            },
            {
                model: 'start',
                name: 'Start',
                acceptableTypes: ['DATE'],
                group: 'validate',
                optional: false,
                multiField: false,
                description:
                    'Try adding a date dimension (i.e. Task Start Date) of the format YYYY-MM-DD.',
            },
            {
                model: 'end',
                name: 'End',
                acceptableTypes: ['DATE'],
                group: 'validate',
                optional: false,
                multiField: false,
                description:
                    'Try adding a date dimension (i.e. Task End Date) of the format YYYY-MM-DD.',
            },
            {
                model: 'group',
                name: 'Task Group',
                acceptableTypes: ['STRING', 'NUMBER'],
                group: 'validate',
                optional: true,
                multiField: false,
                description:
                    'Try adding one categorical dimension (i.e. Sprint Number). Each instance will represent the color of each task. Try the Group View additional tool!',
            },
            {
                model: 'progress',
                name: 'Task Progress',
                acceptableTypes: ['STRING', 'NUMBER', 'DATE'],
                group: 'math',
                optional: true,
                multiField: false,
                description:
                    'Try adding one numerical dimension (0 - 100). This dimension will show how complete each individual task is.',
            },
            {
                model: 'milestone',
                name: 'Milestone',
                acceptableTypes: ['DATE'],
                group: 'validate',
                optional: true,
                multiField: false,
                description:
                    'Try adding a date dimension (i.e. Milestone Date) of the format YYYY-MM-DD.',
            },
            {
                model: 'tooltip',
                name: 'Tooltip',
                acceptableTypes: ['STRING', 'NUMBER', 'DATE'],
                group: 'math',
                optional: true,
                multiField: true,
                description:
                    'Try adding one or several dimensions (i.e. Level of Effort). Each dimension will appear in the tooltip when hovering.',
            },
            {
                model: 'facet',
                name: 'Facet',
                acceptableTypes: ['STRING', 'DATE'],
                group: 'validate',
                optional: true,
                multiField: false,
                description:
                    'Try adding one dimension (i.e. Project Team). The data will be grouped by each instance of the selected dimension.',
            },
        ],
        color: {
            start: {
                multiField: true,
                instances: false,
            },
            end: {
                multiField: true,
                instances: false,
            },
        },
    },
    tools: {
        readOnly: false,
    },
    lazy: true,
};
