module.exports = {
    name: 'Graph',
    icon: require('images/graph.svg'),
    widgetList: {
        tags: ['Visualization'],
        showOn: 'none',
        quickMenu: [
            'events',
            'graph-freeze',
            'graph-unfreeze',
            'unfilter',
            'display-values',
            'color-by-value',
            'infinite-viz',
        ],
    },
    content: {
        template: {
            name: 'graph-standard',
        },
    },
    visualization: {
        type: ['standard'],
        group: 'Visualization',
        view: 'visualization',
        layout: 'Graph',
        visibleModes: [
            'default-mode',
            'comment-mode',
            'edit-mode',
            'brush-mode',
        ],
        tools: [
            'custom-legend',
            'filter',
            'unfilter',
            'display-values',
            'change-layout',
            'cluster-color',
            'graph-remove-intermediary-node',
            'graph-node-details',
            'graph-connected-nodes',
            'graph-find-paths-connecting-nodes',
            'graph-find-paths-connecting-groups',
            'show-direction',
            'color-by-value',
            'graph-freeze',
            'graph-unfreeze',
            'graph-highlight',
            'graph-reset-highlight',
            'traverse',
            'toggle-canvas',
            'events',
            'param',
            'purge',
            'refresh-cache',
        ],
        showOnVisualPanel: false,
        format: 'graph',
        fields: [
            {
                model: 'start',
                name: 'Start',
                acceptableTypes: ['DATE', 'STRING', 'NUMBER'],
                optional: false,
                multiField: true,
                description:
                    'Try adding one or several dimensions (i.e. Nominated). Each instance of this dimension will represent a point on the graph. Each dimension is represented by a specific color. Start and End dimension of the same index will connect.',
            },
            {
                model: 'end',
                name: 'End',
                acceptableTypes: ['DATE', 'STRING', 'NUMBER'],
                optional: false,
                multiField: true,
                description:
                    'Try adding one or several dimensions (i.e. Producer). Each instance of this dimension will represent a point on the graph. Each dimension is represented by a specific color. Start and End dimension of the same index will connect.',
            },
            {
                model: 'facet',
                name: 'Facet',
                acceptableTypes: ['STRING', 'DATE'],
                group: 'validate',
                optional: true,
                multiField: false,
                description:
                    'Try adding one dimension (i.e. Genre). The data will be grouped by each instance of the selected dimension.',
            },
        ],
        color: {},
    },
    state: {
        propertiesTableToggle: false,
        graphLockToggle: false,
        highlightOption: null,
        selectedNode: null,
        traverseList: {},
    },
    lazy: true,
};
