module.exports = {
    name: 'Multi Line',
    icon: require('images/multi-line.svg'),
    widgetList: {
        tags: ['Visualization'],
        showOn: 'none',
        quickMenu: [
            'events',
            'unfilter',
            'color-panel-mode',
            'color-by-value',
            'toggle-zoom-x',
            'toggle-zoom-y',
            'flip-axis',
            'reverse-y',
            'toggle-trendline-mode',
            'infinite-viz',
        ],
    },
    content: {
        template: {
            name: 'multi-line-echarts',
        },
    },
    visualization: {
        type: ['echarts'],
        group: 'Visualization',
        view: 'visualization',
        layout: 'MultiLine',
        visibleModes: ['default-mode', 'comment-mode'],
        tools: [
            //Check
            'legend-viz',
            'custom-legend',
            'filter',
            'unfilter',
            'curve-type',
            'line-style',
            'color-panel',
            'display-values',
            'format-data-values',
            'customize-bar-label',
            'edit-x-axis',
            'edit-y-axis',
            'edit-grid',
            'font-settings',
            'flip-axis',
            'flip-series',
            'reverse-y',
            'sort-values',
            'toggle-extremes',
            'toggle-average',
            //'toggle-legend',
            'toggle-tooltips',
            'display-sum',
            'toggle-trendline',
            'toggle-zoom-x',
            'toggle-zoom-y',
            'axis-pointer',
            'mark-line',
            'mark-area',
            'color-by-value',
            'facet-headers',
            'reset-state',
            'events',
            'param',
            'purge',
            'refresh-cache',
            'symbol-style',
            'chart-title',
        ],
        showOnVisualPanel: true,
        visualPanelMenu: {
            USE: 'Trends', //Check
        },
        format: 'table',
        fields: [
            {
                model: 'label',
                name: 'X-Axis',
                acceptableTypes: ['STRING', 'NUMBER', 'DATE'],
                group: 'validate',
                optional: false,
                multiField: false,
                description:
                    'Try adding one categorical dimension (i.e. Movie Genre). Each instance within this dimension will appear on the x-axis.',
            },
            {
                model: 'value',
                name: 'Y-Axis',
                acceptableTypes: ['NUMBER'],
                group: 'math',
                optional: false,
                multiField: false,
                description:
                    'Try adding one or several dimensions (i.e. Movie Budget). Each dimension will represent a line.',
            },
            {
                model: 'category',
                name: 'Category',
                acceptableTypes: ['STRING', 'NUMBER', 'DATE'],
                group: 'validate',
                optional: false,
                multiField: false,
                description:
                    'Try adding one more third dimension (i.e. Movie Genre). Each instance within this dimension will separate the grid box.',
            },
            {
                model: 'tooltip',
                name: 'Tooltip',
                acceptableTypes: ['STRING', 'NUMBER', 'DATE'],
                group: 'math',
                optional: true,
                multiField: true,
                description:
                    'Try adding one or several dimensions (i.e. Movie Revenue). Each instance of this dimension will appear in the tooltip when hovering.',
            },
            {
                model: 'facet',
                name: 'Facet',
                acceptableTypes: ['STRING', 'DATE'],
                group: 'validate',
                optional: true,
                multiField: false,
                description:
                    'Try adding one dimension (i.e. Nominated). The data will be grouped by each instance of the selected dimension.',
            },
        ],
        color: {
            value: {
                multiField: true,
                instances: false,
            },
        },
        layers: ['Area', 'Column', 'Line'],
    },
    tools: {
        //check
        curveType: 'Smooth',
    },
    lazy: true,
};
