/*
 * Decompiled with CFR 0.152.
 */
package org.osjava.jardiff;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.osjava.jardiff.AbstractInfo;
import org.osjava.jardiff.ClassInfo;
import org.osjava.jardiff.ClassInfoVisitor;
import org.osjava.jardiff.DiffCriteria;
import org.osjava.jardiff.DiffException;
import org.osjava.jardiff.DiffHandler;
import org.osjava.jardiff.FieldInfo;
import org.osjava.jardiff.MethodInfo;

public class JarDiff {
    protected Map depClassInfo = new HashMap();
    protected Map<String, ClassInfo> oldClassInfo = new TreeMap<String, ClassInfo>();
    protected Map<String, ClassInfo> newClassInfo = new TreeMap<String, ClassInfo>();
    private URL[] deps;
    private URLClassLoader depLoader;
    private String oldVersion;
    private String newVersion;
    private ClassInfoVisitor infoVisitor = new ClassInfoVisitor();

    public void setOldVersion(String oldVersion) {
        this.oldVersion = oldVersion;
    }

    public String getOldVersion() {
        return this.oldVersion;
    }

    public void setNewVersion(String newVersion) {
        this.newVersion = newVersion;
    }

    public String getNewVersion() {
        return this.newVersion;
    }

    public void setDependencies(URL[] deps) {
        this.deps = deps;
    }

    public URL[] getDependencies() {
        return this.deps;
    }

    public synchronized ClassInfo loadClassInfo(ClassReader reader) throws IOException {
        this.infoVisitor.reset();
        reader.accept((ClassVisitor)this.infoVisitor, 0);
        return this.infoVisitor.getClassInfo();
    }

    private void loadClasses(Map infoMap, URL path) throws DiffException {
        try {
            File jarFile = null;
            if (!"file".equals(path.getProtocol()) || path.getHost() != null) {
                int i;
                jarFile = File.createTempFile("jardiff", "jar");
                jarFile.deleteOnExit();
                InputStream in = path.openStream();
                FileOutputStream out = new FileOutputStream(jarFile);
                byte[] buffer = new byte[4096];
                while ((i = in.read(buffer, 0, buffer.length)) != -1) {
                    ((OutputStream)out).write(buffer, 0, i);
                }
                in.close();
                ((OutputStream)out).close();
            } else {
                jarFile = new File(path.getPath());
            }
            this.loadClasses(infoMap, jarFile);
        }
        catch (IOException ioe) {
            throw new DiffException(ioe);
        }
    }

    private void loadClasses(Map infoMap, File file) throws DiffException {
        try {
            JarFile jar = new JarFile(file);
            Enumeration<JarEntry> e = jar.entries();
            while (e.hasMoreElements()) {
                JarEntry entry = e.nextElement();
                String name = entry.getName();
                if (entry.isDirectory() || !name.endsWith(".class")) continue;
                ClassReader reader = new ClassReader(jar.getInputStream(entry));
                ClassInfo ci = this.loadClassInfo(reader);
                infoMap.put(ci.getName(), ci);
            }
        }
        catch (IOException ioe) {
            throw new DiffException(ioe);
        }
    }

    public void loadOldClasses(URL loc) throws DiffException {
        this.loadClasses(this.oldClassInfo, loc);
    }

    public void loadNewClasses(URL loc) throws DiffException {
        this.loadClasses(this.newClassInfo, loc);
    }

    public void loadOldClasses(File file) throws DiffException {
        this.loadClasses(this.oldClassInfo, file);
    }

    public void loadNewClasses(File file) throws DiffException {
        this.loadClasses(this.newClassInfo, file);
    }

    public void diff(DiffHandler handler, DiffCriteria criteria) throws DiffException {
        this.diff(handler, criteria, this.oldVersion, this.newVersion, this.oldClassInfo, this.newClassInfo);
    }

    public void diff(DiffHandler handler, DiffCriteria criteria, String oldVersion, String newVersion, Map<String, ClassInfo> oldClassInfo, Map<String, ClassInfo> newClassInfo) throws DiffException {
        ClassInfo ci;
        handler.startDiff(oldVersion, newVersion);
        handler.startOldContents();
        for (ClassInfo ci2 : oldClassInfo.values()) {
            if (!criteria.validClass(ci2)) continue;
            handler.contains(ci2);
        }
        handler.endOldContents();
        handler.startNewContents();
        for (ClassInfo ci2 : newClassInfo.values()) {
            if (!criteria.validClass(ci2)) continue;
            handler.contains(ci2);
        }
        handler.endNewContents();
        TreeSet<String> onlyOld = new TreeSet<String>(oldClassInfo.keySet());
        TreeSet<String> onlyNew = new TreeSet<String>(newClassInfo.keySet());
        TreeSet<String> both = new TreeSet<String>(oldClassInfo.keySet());
        onlyOld.removeAll(newClassInfo.keySet());
        onlyNew.removeAll(oldClassInfo.keySet());
        both.retainAll(newClassInfo.keySet());
        handler.startRemoved();
        for (String s : onlyOld) {
            ci = oldClassInfo.get(s);
            if (!criteria.validClass(ci)) continue;
            handler.classRemoved(ci);
        }
        handler.endRemoved();
        handler.startAdded();
        for (String s : onlyNew) {
            ci = newClassInfo.get(s);
            if (!criteria.validClass(ci)) continue;
            handler.classAdded(ci);
        }
        handler.endAdded();
        TreeSet<String> removedMethods = new TreeSet<String>();
        TreeSet<String> removedFields = new TreeSet<String>();
        TreeSet<String> addedMethods = new TreeSet<String>();
        TreeSet<String> addedFields = new TreeSet<String>();
        TreeSet<String> changedMethods = new TreeSet<String>();
        TreeSet<String> changedFields = new TreeSet<String>();
        handler.startChanged();
        for (String s : both) {
            AbstractInfo newInfo;
            ClassInfo oci = oldClassInfo.get(s);
            ClassInfo nci = newClassInfo.get(s);
            if (!criteria.validClass(oci) && !criteria.validClass(nci)) continue;
            Map<String, MethodInfo> oldMethods = oci.getMethodMap();
            Map<String, FieldInfo> oldFields = oci.getFieldMap();
            Map<String, MethodInfo> newMethods = nci.getMethodMap();
            Map<String, FieldInfo> newFields = nci.getFieldMap();
            HashMap<String, MethodInfo> extNewMethods = new HashMap<String, MethodInfo>(newMethods);
            HashMap<String, FieldInfo> extNewFields = new HashMap<String, FieldInfo>(newFields);
            String superClass = nci.getSupername();
            while (superClass != null && newClassInfo.containsKey(superClass)) {
                ClassInfo sci = newClassInfo.get(superClass);
                for (Map.Entry<String, FieldInfo> entry : sci.getFieldMap().entrySet()) {
                    if (entry.getValue().isPrivate() || extNewFields.containsKey(entry.getKey())) continue;
                    extNewFields.put(entry.getKey(), entry.getValue());
                }
                for (Map.Entry<String, MethodInfo> entry : sci.getMethodMap().entrySet()) {
                    if (entry.getValue().isPrivate() || extNewMethods.containsKey(entry.getKey())) continue;
                    extNewMethods.put(entry.getKey(), entry.getValue());
                }
                superClass = sci.getSupername();
            }
            for (Map.Entry<String, MethodInfo> entry : oldMethods.entrySet()) {
                if (!criteria.validMethod(entry.getValue())) continue;
                removedMethods.add(entry.getKey());
            }
            for (Map.Entry<String, AbstractInfo> entry : oldFields.entrySet()) {
                if (!criteria.validField((FieldInfo)entry.getValue())) continue;
                removedFields.add(entry.getKey());
            }
            for (Map.Entry<String, AbstractInfo> entry : newMethods.entrySet()) {
                if (!criteria.validMethod((MethodInfo)entry.getValue())) continue;
                addedMethods.add(entry.getKey());
            }
            for (Map.Entry<String, AbstractInfo> entry : newFields.entrySet()) {
                if (!criteria.validField((FieldInfo)entry.getValue())) continue;
                addedFields.add(entry.getKey());
            }
            changedMethods.addAll(removedMethods);
            changedMethods.retainAll(addedMethods);
            removedMethods.removeAll(changedMethods);
            removedMethods.removeAll(extNewMethods.keySet());
            addedMethods.removeAll(changedMethods);
            changedFields.addAll(removedFields);
            changedFields.retainAll(addedFields);
            removedFields.removeAll(changedFields);
            removedFields.removeAll(extNewFields.keySet());
            addedFields.removeAll(changedFields);
            Iterator j = changedMethods.iterator();
            while (j.hasNext()) {
                String string = (String)j.next();
                MethodInfo methodInfo = oldMethods.get(string);
                if (criteria.differs(methodInfo, (MethodInfo)(newInfo = newMethods.get(string)))) continue;
                j.remove();
            }
            j = changedFields.iterator();
            while (j.hasNext()) {
                String string = (String)j.next();
                FieldInfo fieldInfo = oldFields.get(string);
                if (criteria.differs(fieldInfo, (FieldInfo)(newInfo = newFields.get(string)))) continue;
                j.remove();
            }
            boolean bl = criteria.differs(oci, nci);
            if (!bl && removedMethods.isEmpty() && removedFields.isEmpty() && addedMethods.isEmpty() && addedFields.isEmpty() && changedMethods.isEmpty() && changedFields.isEmpty()) continue;
            handler.startClassChanged(s);
            handler.startRemoved();
            for (String field : removedFields) {
                handler.fieldRemoved(oldFields.get(field));
            }
            for (String method : removedMethods) {
                handler.methodRemoved(oldMethods.get(method));
            }
            handler.endRemoved();
            handler.startAdded();
            for (String field : addedFields) {
                handler.fieldAdded(newFields.get(field));
            }
            for (String method : addedMethods) {
                handler.methodAdded(newMethods.get(method));
            }
            handler.endAdded();
            handler.startChanged();
            if (bl) {
                if (JarDiff.wasDeprecated(oci, nci) && !criteria.differs(JarDiff.cloneDeprecated(oci), nci)) {
                    handler.classDeprecated(oci, nci);
                } else {
                    handler.classChanged(oci, nci);
                }
            }
            for (String field : changedFields) {
                FieldInfo newFieldInfo;
                FieldInfo oldFieldInfo = oldFields.get(field);
                if (JarDiff.wasDeprecated(oldFieldInfo, newFieldInfo = newFields.get(field)) && !criteria.differs(JarDiff.cloneDeprecated(oldFieldInfo), newFieldInfo)) {
                    handler.fieldDeprecated(oldFieldInfo, newFieldInfo);
                    continue;
                }
                handler.fieldChanged(oldFieldInfo, newFieldInfo);
            }
            for (String method : changedMethods) {
                MethodInfo newMethodInfo;
                MethodInfo oldMethodInfo = oldMethods.get(method);
                if (JarDiff.wasDeprecated(oldMethodInfo, newMethodInfo = newMethods.get(method)) && !criteria.differs(JarDiff.cloneDeprecated(oldMethodInfo), newMethodInfo)) {
                    handler.methodDeprecated(oldMethodInfo, newMethodInfo);
                    continue;
                }
                handler.methodChanged(oldMethodInfo, newMethodInfo);
            }
            handler.endChanged();
            handler.endClassChanged();
            removedMethods.clear();
            removedFields.clear();
            addedMethods.clear();
            addedFields.clear();
            changedMethods.clear();
            changedFields.clear();
        }
        handler.endChanged();
        handler.endDiff();
    }

    private static boolean wasDeprecated(AbstractInfo oldInfo, AbstractInfo newInfo) {
        return !oldInfo.isDeprecated() && newInfo.isDeprecated();
    }

    private static ClassInfo cloneDeprecated(ClassInfo classInfo) {
        return new ClassInfo(classInfo.getVersion(), classInfo.getAccess() | 0x20000, classInfo.getName(), classInfo.getSignature(), classInfo.getSupername(), classInfo.getInterfaces(), classInfo.getMethodMap(), classInfo.getFieldMap());
    }

    private static MethodInfo cloneDeprecated(MethodInfo methodInfo) {
        return new MethodInfo(methodInfo.getAccess() | 0x20000, methodInfo.getName(), methodInfo.getDesc(), methodInfo.getSignature(), methodInfo.getExceptions());
    }

    private static FieldInfo cloneDeprecated(FieldInfo fieldInfo) {
        return new FieldInfo(fieldInfo.getAccess() | 0x20000, fieldInfo.getName(), fieldInfo.getDesc(), fieldInfo.getSignature(), fieldInfo.getValue());
    }
}

