/*
 * Decompiled with CFR 0.152.
 */
package org.semver;

import java.util.Collections;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import org.osjava.jardiff.AbstractInfo;
import org.semver.Version;

@Immutable
public final class Delta {
    private final Set<Difference> differences;

    public Delta(@Nonnull Set<? extends Difference> differences) {
        this.differences = Collections.unmodifiableSet(differences);
    }

    @Nonnull
    public final Set<Difference> getDifferences() {
        return this.differences;
    }

    @Nonnull
    public final CompatibilityType computeCompatibilityType() {
        if (this.contains(this.differences, Change.class) || this.contains(this.differences, Remove.class)) {
            return CompatibilityType.NON_BACKWARD_COMPATIBLE;
        }
        if (this.contains(this.differences, Add.class) || this.contains(this.differences, Deprecate.class)) {
            return CompatibilityType.BACKWARD_COMPATIBLE_USER;
        }
        return CompatibilityType.BACKWARD_COMPATIBLE_IMPLEMENTER;
    }

    protected final boolean contains(Set<Difference> differences, Class<? extends Difference> type) {
        for (Difference difference : differences) {
            if (!type.isInstance(difference)) continue;
            return true;
        }
        return false;
    }

    @Nonnull
    public static Version inferNextVersion(@Nonnull Version version, @Nonnull CompatibilityType compatibilityType) {
        if (version == null) {
            throw new IllegalArgumentException("null version");
        }
        if (compatibilityType == null) {
            throw new IllegalArgumentException("null compatibilityType");
        }
        switch (compatibilityType) {
            case BACKWARD_COMPATIBLE_IMPLEMENTER: {
                return version.next(Version.Element.PATCH);
            }
            case BACKWARD_COMPATIBLE_USER: {
                return version.next(Version.Element.MINOR);
            }
            case NON_BACKWARD_COMPATIBLE: {
                return version.next(Version.Element.MAJOR);
            }
        }
        throw new IllegalArgumentException("Unknown type <" + (Object)((Object)compatibilityType) + ">");
    }

    @Nonnull
    public final Version infer(@Nonnull Version previous) {
        if (previous == null) {
            throw new IllegalArgumentException("null previous");
        }
        if (previous.isInDevelopment()) {
            throw new IllegalArgumentException("Cannot infer for in development version <" + previous + ">");
        }
        CompatibilityType compatibilityType = this.computeCompatibilityType();
        return Delta.inferNextVersion(previous, compatibilityType);
    }

    public final boolean validate(@Nonnull Version previous, @Nonnull Version current) {
        if (previous == null) {
            throw new IllegalArgumentException("null previous");
        }
        if (current == null) {
            throw new IllegalArgumentException("null current");
        }
        if (current.compareTo(previous) <= 0) {
            throw new IllegalArgumentException("Current version <" + previous + "> must be more recent than previous version <" + current + ">.");
        }
        if (current.isInDevelopment()) {
            return true;
        }
        Version inferredVersion = this.infer(previous);
        return current.compareTo(inferredVersion) >= 0;
    }

    @Immutable
    public static class Remove
    extends Difference {
        public Remove(@Nonnull String className, @Nonnull AbstractInfo info) {
            super(className, info);
        }
    }

    @Immutable
    public static class Deprecate
    extends Difference {
        private final AbstractInfo modifiedInfo;

        public Deprecate(@Nonnull String className, @Nonnull AbstractInfo info, @Nonnull AbstractInfo modifiedInfo) {
            super(className, info);
            this.modifiedInfo = modifiedInfo;
        }

        public AbstractInfo getModifiedInfo() {
            return this.modifiedInfo;
        }
    }

    @Immutable
    public static class Change
    extends Difference {
        private final AbstractInfo modifiedInfo;

        public Change(@Nonnull String className, @Nonnull AbstractInfo info, @Nonnull AbstractInfo modifiedInfo) {
            super(className, info);
            this.modifiedInfo = modifiedInfo;
        }

        public AbstractInfo getModifiedInfo() {
            return this.modifiedInfo;
        }
    }

    @Immutable
    public static class Add
    extends Difference {
        public Add(@Nonnull String className, @Nonnull AbstractInfo info) {
            super(className, info);
        }
    }

    @Immutable
    public static class Difference
    implements Comparable<Difference> {
        private final String className;
        private final AbstractInfo info;

        public Difference(@Nonnull String className, @Nonnull AbstractInfo info) {
            if (className == null) {
                throw new IllegalArgumentException("null className");
            }
            if (info == null) {
                throw new IllegalArgumentException("null info");
            }
            this.className = className;
            this.info = info;
        }

        @Nonnull
        public String getClassName() {
            return this.className;
        }

        @Nonnull
        public AbstractInfo getInfo() {
            return this.info;
        }

        @Override
        public int compareTo(Difference other) {
            return this.getClassName().compareTo(other.getClassName());
        }
    }

    public static enum CompatibilityType {
        BACKWARD_COMPATIBLE_IMPLEMENTER,
        BACKWARD_COMPATIBLE_USER,
        NON_BACKWARD_COMPATIBLE;

    }
}

