/*
 * Decompiled with CFR 0.152.
 */
package org.semver;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.osjava.jardiff.AbstractInfo;
import org.osjava.jardiff.ClassInfo;
import org.semver.Delta;

public class Dumper {
    private Dumper() {
    }

    protected static String extractActionType(Delta.Difference difference) {
        String actionType = difference.getClass().getSimpleName();
        return actionType.endsWith("e") ? actionType + "d" : actionType + "ed";
    }

    protected static String extractInfoType(AbstractInfo info) {
        String simpleClassName = info.getClass().getSimpleName();
        return simpleClassName.substring(0, simpleClassName.indexOf("Info"));
    }

    protected static String extractDetails(Delta.Difference difference) {
        if (difference instanceof Delta.Change) {
            Delta.Change change = (Delta.Change)difference;
            return Dumper.extractDetails(difference.getInfo()) + ", access " + Dumper.extractAccessDetails(difference.getInfo(), change.getModifiedInfo());
        }
        return Dumper.extractDetails(difference.getInfo()) + ", access " + Dumper.extractAccessDetails(difference.getInfo());
    }

    protected static String extractDetails(AbstractInfo info) {
        StringBuilder builder = new StringBuilder();
        if (!(info instanceof ClassInfo)) {
            builder.append(info.getName());
            if (null != info.getSignature()) {
                builder.append(", sig ").append(info.getSignature());
            }
            if (null != info.getDesc()) {
                builder.append(", desc ").append(info.getDesc());
            }
        }
        return builder.toString();
    }

    protected static void accumulateAccessDetails(String access, boolean previousAccess, boolean currentAccess, List<String> added, List<String> removed) {
        if (previousAccess != currentAccess) {
            if (previousAccess) {
                removed.add(access);
            } else {
                added.add(access);
            }
        }
    }

    protected static String extractAccessDetails(AbstractInfo previousInfo, AbstractInfo currentInfo) {
        LinkedList<String> added = new LinkedList<String>();
        LinkedList<String> removed = new LinkedList<String>();
        Dumper.accumulateAccessDetails("abstract", previousInfo.isAbstract(), currentInfo.isAbstract(), added, removed);
        Dumper.accumulateAccessDetails("annotation", previousInfo.isAnnotation(), currentInfo.isAnnotation(), added, removed);
        Dumper.accumulateAccessDetails("bridge", previousInfo.isBridge(), currentInfo.isBridge(), added, removed);
        Dumper.accumulateAccessDetails("enum", previousInfo.isEnum(), currentInfo.isEnum(), added, removed);
        Dumper.accumulateAccessDetails("final", previousInfo.isFinal(), currentInfo.isFinal(), added, removed);
        Dumper.accumulateAccessDetails("interface", previousInfo.isInterface(), currentInfo.isInterface(), added, removed);
        Dumper.accumulateAccessDetails("native", previousInfo.isNative(), currentInfo.isNative(), added, removed);
        Dumper.accumulateAccessDetails("package-private", previousInfo.isPackagePrivate(), currentInfo.isPackagePrivate(), added, removed);
        Dumper.accumulateAccessDetails("private", previousInfo.isPrivate(), currentInfo.isPrivate(), added, removed);
        Dumper.accumulateAccessDetails("protected", previousInfo.isProtected(), currentInfo.isProtected(), added, removed);
        Dumper.accumulateAccessDetails("public", previousInfo.isPublic(), currentInfo.isPublic(), added, removed);
        Dumper.accumulateAccessDetails("static", previousInfo.isStatic(), currentInfo.isStatic(), added, removed);
        Dumper.accumulateAccessDetails("strict", previousInfo.isStrict(), currentInfo.isStrict(), added, removed);
        Dumper.accumulateAccessDetails("super", previousInfo.isSuper(), currentInfo.isSuper(), added, removed);
        Dumper.accumulateAccessDetails("synchronized", previousInfo.isSynchronized(), currentInfo.isSynchronized(), added, removed);
        Dumper.accumulateAccessDetails("synthetic", previousInfo.isSynthetic(), currentInfo.isSynthetic(), added, removed);
        Dumper.accumulateAccessDetails("transcient", previousInfo.isTransient(), currentInfo.isTransient(), added, removed);
        Dumper.accumulateAccessDetails("varargs", previousInfo.isVarargs(), currentInfo.isVarargs(), added, removed);
        Dumper.accumulateAccessDetails("volatile", previousInfo.isVolatile(), currentInfo.isVolatile(), added, removed);
        StringBuilder details = new StringBuilder();
        if (!added.isEmpty()) {
            details.append("added: ");
            for (String access : added) {
                details.append(access).append(" ");
            }
        }
        if (!removed.isEmpty()) {
            details.append("removed: ");
            for (String access : removed) {
                details.append(access).append(" ");
            }
        }
        return details.toString().trim();
    }

    protected static void accumulateAccessDetails(String access, boolean hasAccess, List<String> accessList) {
        if (hasAccess) {
            accessList.add(access);
        }
    }

    protected static String extractAccessDetails(AbstractInfo info) {
        LinkedList<String> accessList = new LinkedList<String>();
        Dumper.accumulateAccessDetails("abstract", info.isAbstract(), accessList);
        Dumper.accumulateAccessDetails("annotation", info.isAnnotation(), accessList);
        Dumper.accumulateAccessDetails("bridge", info.isBridge(), accessList);
        Dumper.accumulateAccessDetails("enum", info.isEnum(), accessList);
        Dumper.accumulateAccessDetails("final", info.isFinal(), accessList);
        Dumper.accumulateAccessDetails("interface", info.isInterface(), accessList);
        Dumper.accumulateAccessDetails("native", info.isNative(), accessList);
        Dumper.accumulateAccessDetails("package-private", info.isPackagePrivate(), accessList);
        Dumper.accumulateAccessDetails("private", info.isPrivate(), accessList);
        Dumper.accumulateAccessDetails("protected", info.isProtected(), accessList);
        Dumper.accumulateAccessDetails("public", info.isPublic(), accessList);
        Dumper.accumulateAccessDetails("static", info.isStatic(), accessList);
        Dumper.accumulateAccessDetails("strict", info.isStrict(), accessList);
        Dumper.accumulateAccessDetails("super", info.isSuper(), accessList);
        Dumper.accumulateAccessDetails("synchronized", info.isSynchronized(), accessList);
        Dumper.accumulateAccessDetails("synthetic", info.isSynthetic(), accessList);
        Dumper.accumulateAccessDetails("transcient", info.isTransient(), accessList);
        Dumper.accumulateAccessDetails("varargs", info.isVarargs(), accessList);
        Dumper.accumulateAccessDetails("volatile", info.isVolatile(), accessList);
        StringBuilder details = new StringBuilder();
        if (!accessList.isEmpty()) {
            for (String access : accessList) {
                details.append(access).append(" ");
            }
        }
        return details.toString().trim();
    }

    public static void dump(Delta delta) {
        Dumper.dump(delta, System.out);
    }

    public static void dump(Delta delta, PrintStream out) {
        LinkedList<Delta.Difference> sortedDifferences = new LinkedList<Delta.Difference>(delta.getDifferences());
        Collections.sort(sortedDifferences);
        Dumper.dump(sortedDifferences, out);
    }

    public static void dump(List<Delta.Difference> sortedDifferences, PrintStream out) {
        String currentClassName = "";
        for (Delta.Difference difference : sortedDifferences) {
            if (!currentClassName.equals(difference.getClassName())) {
                out.println("Class " + difference.getClassName());
            }
            out.println(" " + Dumper.extractActionType(difference) + " " + Dumper.extractInfoType(difference.getInfo()) + " " + Dumper.extractDetails(difference));
            currentClassName = difference.getClassName();
        }
    }

    public static void dumpFullStats(Delta delta, int iwidth, PrintStream out) {
        Set<Delta.Difference> diffs = delta.getDifferences();
        ArrayList<Delta.Difference> diffsAdd = new ArrayList<Delta.Difference>();
        ArrayList<Delta.Difference> diffsChange = new ArrayList<Delta.Difference>();
        ArrayList<Delta.Difference> diffsDeprecate = new ArrayList<Delta.Difference>();
        ArrayList<Delta.Difference> diffsRemove = new ArrayList<Delta.Difference>();
        HashMap<String, DiffCount> className2DiffCount = new HashMap<String, DiffCount>();
        int maxClassNameLen = 0;
        for (Delta.Difference diff : diffs) {
            String className = diff.getClassName();
            maxClassNameLen = Math.max(maxClassNameLen, className.length());
            DiffCount dc = (DiffCount)className2DiffCount.get(className);
            if (null == dc) {
                dc = new DiffCount(className);
                className2DiffCount.put(className, dc);
            }
            if (diff instanceof Delta.Add) {
                diffsAdd.add(diff);
                ++dc.additions;
                continue;
            }
            if (diff instanceof Delta.Change) {
                diffsChange.add(diff);
                ++dc.changes;
                continue;
            }
            if (diff instanceof Delta.Deprecate) {
                diffsDeprecate.add(diff);
                ++dc.deprecates;
                continue;
            }
            if (!(diff instanceof Delta.Remove)) continue;
            diffsRemove.add(diff);
            ++dc.removes;
        }
        Collections.sort(diffsAdd);
        Collections.sort(diffsChange);
        Collections.sort(diffsDeprecate);
        Collections.sort(diffsRemove);
        ArrayList classNames = new ArrayList(className2DiffCount.keySet());
        Collections.sort(classNames);
        System.err.println("Summary: " + diffs.size() + " differences in " + classNames.size() + " classes:");
        System.err.println("  Remove " + diffsRemove.size() + ", Change " + diffsChange.size() + ", Deprecate " + diffsDeprecate.size() + ", Add " + diffsAdd.size());
        System.err.printf("%n", new Object[0]);
        int iterI = 0;
        for (String className : classNames) {
            DiffCount dc = (DiffCount)className2DiffCount.get(className);
            System.err.printf("%" + iwidth + "d/%" + iwidth + "d: %-" + maxClassNameLen + "s: %s%n", iterI, classNames.size(), className, dc.format(iwidth));
            ++iterI;
        }
        System.err.printf("%n%nRemoves%n%n", new Object[0]);
        Dumper.dump(diffsRemove, System.err);
        System.err.printf("%n%nChanges%n%n", new Object[0]);
        Dumper.dump(diffsChange, System.err);
        System.err.printf("%n%nDeprecates%n%n", new Object[0]);
        Dumper.dump(diffsDeprecate, System.err);
        System.err.printf("%n%nAdditions%n%n", new Object[0]);
        Dumper.dump(diffsAdd, System.err);
        System.err.printf("%n%n", new Object[0]);
    }

    static class DiffCount {
        public final String name;
        public int removes;
        public int changes;
        public int deprecates;
        public int additions;

        public DiffCount(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name + ": Remove " + this.removes + ", Change " + this.changes + ", Deprecate " + this.deprecates + ", Add " + this.additions;
        }

        public String format(int iwidth) {
            return String.format("Remove %" + iwidth + "d, Change %" + iwidth + "d, Deprecate %" + iwidth + "d, Add %" + iwidth + "d", this.removes, this.changes, this.deprecates, this.additions);
        }
    }
}

