/*
 * Decompiled with CFR 0.152.
 */
package org.semver;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.apache.commons.lang.StringUtils;

@Immutable
public final class Version
implements Comparable<Version> {
    private static final String FORMAT = "(\\d+)\\.(\\d+)(?:\\.)?(\\d*)(\\.|-|\\+)?([0-9A-Za-z-.]*)?";
    private static final Pattern PATTERN = Pattern.compile("(\\d+)\\.(\\d+)(?:\\.)?(\\d*)(\\.|-|\\+)?([0-9A-Za-z-.]*)?");
    private static final Pattern DIGITS_ONLY = Pattern.compile("\\d+");
    private static final String SNAPSHOT_VERSION_SUFFIX = "-SNAPSHOT";
    private final int major;
    private final int minor;
    private final int patch;
    private final String separator;
    private final Special special;

    public Version(@Nonnegative int major, @Nonnegative int minor, @Nonnegative int patch) {
        this(major, minor, patch, null, null);
    }

    public Version(@Nonnegative int major, @Nonnegative int minor, @Nonnegative int patch, @Nullable String separator, @Nullable String special) {
        if (major < 0) {
            throw new IllegalArgumentException((Object)((Object)Element.MAJOR) + " must be positive");
        }
        if (minor < 0) {
            throw new IllegalArgumentException((Object)((Object)Element.MINOR) + " must be positive");
        }
        if (patch < 0) {
            throw new IllegalArgumentException((Object)((Object)Element.PATCH) + " must be positive");
        }
        this.major = major;
        this.minor = minor;
        this.patch = patch;
        this.separator = separator;
        this.special = this.parseSpecial(special);
    }

    private Special parseSpecial(String specialString) {
        if (specialString == null) {
            return null;
        }
        Special special = new Special(specialString);
        if (special.ids.length == 0) {
            return null;
        }
        return special;
    }

    public static Version parse(@Nonnull String version) {
        Matcher matcher = PATTERN.matcher(version);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("<" + version + "> does not match format " + FORMAT);
        }
        int major = Integer.valueOf(matcher.group(1));
        int minor = Integer.valueOf(matcher.group(2));
        String patchMatch = matcher.group(3);
        int patch = StringUtils.isNotEmpty((String)patchMatch) ? Integer.valueOf(patchMatch) : 0;
        String separator = matcher.group(4);
        String special = matcher.group(5);
        return new Version(major, minor, patch, separator, "".equals(special) ? null : special);
    }

    public Version next(@Nonnull Element element) {
        if (element == null) {
            throw new IllegalArgumentException("null element");
        }
        switch (element) {
            case MAJOR: {
                if (this.special == null || this.minor != 0 || this.patch != 0) {
                    return new Version(this.major + 1, 0, 0);
                }
                return new Version(this.major, 0, 0);
            }
            case MINOR: {
                if (this.special == null || this.patch != 0) {
                    return new Version(this.major, this.minor + 1, 0);
                }
                return new Version(this.major, this.minor, 0);
            }
            case PATCH: {
                if (this.special == null) {
                    return new Version(this.major, this.minor, this.patch + 1);
                }
                return new Version(this.major, this.minor, this.patch);
            }
        }
        throw new IllegalArgumentException("Unknown element <" + (Object)((Object)element) + ">");
    }

    public boolean isInDevelopment() {
        return this.major == 0;
    }

    public boolean isStable() {
        return !this.isInDevelopment();
    }

    public boolean isSnapshot() {
        return this.special != null && this.special.isSnapshot();
    }

    public int hashCode() {
        int hash = 5;
        hash = 43 * hash + this.major;
        hash = 43 * hash + this.minor;
        hash = 43 * hash + this.patch;
        hash = 43 * hash + (this.special != null ? this.special.hashCode() : 0);
        return hash;
    }

    public boolean equals(@Nullable Object object) {
        if (!(object instanceof Version)) {
            return false;
        }
        Version other = (Version)object;
        if (other.major != this.major || other.minor != this.minor || other.patch != this.patch) {
            return false;
        }
        return this.special == null ? other.special == null : this.special.equals(other.special);
    }

    private static SpecialId parseSpecialId(String id) {
        Matcher matcher = DIGITS_ONLY.matcher(id);
        if (matcher.matches()) {
            return new IntId(Integer.parseInt(id));
        }
        return new StringId(id);
    }

    @Override
    public int compareTo(Version other) {
        if (this.equals(other)) {
            return 0;
        }
        if (this.major < other.major) {
            return -1;
        }
        if (this.major == other.major) {
            if (this.minor < other.minor) {
                return -1;
            }
            if (this.minor == other.minor) {
                if (this.patch < other.patch) {
                    return -1;
                }
                if (this.patch == other.patch) {
                    if (this.special != null && other.special != null) {
                        return this.special.compareTo(other.special);
                    }
                    if (other.special != null) {
                        return 1;
                    }
                    if (this.special != null) {
                        return -1;
                    }
                }
            }
        }
        return 1;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.major).append(".").append(this.minor).append(".").append(this.patch);
        if (this.separator != null) {
            builder.append(this.separator);
        }
        if (this.special != null) {
            builder.append(this.special);
        }
        return builder.toString();
    }

    private static class Special
    implements Comparable<Special> {
        private final SpecialId[] ids;

        Special(String s) {
            String[] split = s.split("\\.");
            this.ids = new SpecialId[split.length];
            for (int i = 0; i < split.length; ++i) {
                this.ids[i] = Version.parseSpecialId(split[i]);
            }
        }

        public SpecialId last() {
            return this.ids[this.ids.length - 1];
        }

        public boolean isSnapshot() {
            return this.last().isSnapshot();
        }

        @Override
        public int compareTo(Special other) {
            int min = Math.min(other.ids.length, this.ids.length);
            for (int i = 0; i < min; ++i) {
                int c = this.ids[i].compareTo(other.ids[i]);
                if (c == 0) continue;
                return c;
            }
            int max = Math.max(other.ids.length, this.ids.length);
            if (max != min) {
                if (this.ids.length > other.ids.length) {
                    return 1;
                }
                return -1;
            }
            return 0;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            for (int i = 0; i < this.ids.length; ++i) {
                SpecialId s = this.ids[i];
                if (i != 0) {
                    builder.append(".");
                }
                builder.append(s);
            }
            return builder.toString();
        }
    }

    private static class IntId
    extends SpecialId {
        private final int id;

        public IntId(int id) {
            this.id = id;
        }

        @Override
        public boolean isSnapshot() {
            return false;
        }

        public String toString() {
            return String.valueOf(this.id);
        }

        @Override
        public int compareTo(SpecialId other) {
            return -other.compareTo(this);
        }

        @Override
        public int compareTo(IntId other) {
            return this.id - other.id;
        }

        @Override
        public int compareTo(StringId other) {
            return -1;
        }
    }

    private static class StringId
    extends SpecialId {
        private final String id;

        private StringId(String id) {
            this.id = id;
        }

        @Override
        public boolean isSnapshot() {
            return this.id.endsWith(Version.SNAPSHOT_VERSION_SUFFIX);
        }

        @Override
        public int compareTo(SpecialId other) {
            return -other.compareTo(this);
        }

        public String toString() {
            return this.id;
        }

        @Override
        public int compareTo(IntId other) {
            return 1;
        }

        @Override
        public int compareTo(StringId other) {
            return this.id.compareTo(other.id);
        }
    }

    private static abstract class SpecialId
    implements Comparable<SpecialId> {
        private SpecialId() {
        }

        public abstract boolean isSnapshot();

        @Override
        public abstract int compareTo(IntId var1);

        @Override
        public abstract int compareTo(StringId var1);
    }

    public static enum Element {
        MAJOR,
        MINOR,
        PATCH,
        SPECIAL;

    }
}

