/*
 * Decompiled with CFR 0.152.
 */
package org.semver.jardiff;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import org.osjava.jardiff.AbstractDiffHandler;
import org.osjava.jardiff.ClassInfo;
import org.osjava.jardiff.DiffException;
import org.osjava.jardiff.FieldInfo;
import org.osjava.jardiff.MethodInfo;
import org.semver.Delta;

public final class DifferenceAccumulatingHandler
extends AbstractDiffHandler {
    private String currentClassName;
    private final Set<String> includes;
    private final boolean includesAreRegExp;
    private final Set<String> excludes;
    private final boolean excludesAreRegExp;
    private final Set<Delta.Difference> differences = new HashSet<Delta.Difference>();

    public DifferenceAccumulatingHandler() {
        this(Collections.emptySet(), Collections.emptySet());
    }

    public DifferenceAccumulatingHandler(@Nonnull Set<String> includes, @Nonnull Set<String> excludes) {
        this(includes, false, excludes, false);
    }

    public DifferenceAccumulatingHandler(@Nonnull Set<String> includes, boolean includesAreRegExp, @Nonnull Set<String> excludes, boolean excludesAreRegExp) {
        this.includes = includes;
        this.includesAreRegExp = includesAreRegExp;
        this.excludes = excludes;
        this.excludesAreRegExp = excludesAreRegExp;
    }

    public String getCurrentClassName() {
        return this.currentClassName;
    }

    @Override
    public void startDiff(String previous, String current) throws DiffException {
    }

    @Override
    public void endDiff() throws DiffException {
    }

    @Override
    public void startOldContents() throws DiffException {
    }

    @Override
    public void endOldContents() throws DiffException {
    }

    @Override
    public void startNewContents() throws DiffException {
    }

    @Override
    public void endNewContents() throws DiffException {
    }

    @Override
    public void contains(ClassInfo classInfo) throws DiffException {
    }

    @Override
    public void startAdded() throws DiffException {
    }

    @Override
    public void classAdded(ClassInfo classInfo) throws DiffException {
        if (!this.isClassConsidered(classInfo.getName())) {
            return;
        }
        this.differences.add(new Delta.Add(this.getClassName(classInfo.getName()), classInfo));
    }

    @Override
    public void fieldAdded(FieldInfo fieldInfo) throws DiffException {
        if (!this.isClassConsidered(this.getCurrentClassName())) {
            return;
        }
        this.differences.add(new Delta.Add(this.getCurrentClassName(), fieldInfo));
    }

    @Override
    public void methodAdded(MethodInfo methodInfo) throws DiffException {
        if (!this.isClassConsidered(this.getCurrentClassName())) {
            return;
        }
        this.differences.add(new Delta.Add(this.getCurrentClassName(), methodInfo));
    }

    @Override
    public void endAdded() throws DiffException {
    }

    @Override
    public void startChanged() throws DiffException {
    }

    @Override
    public void startClassChanged(String className) throws DiffException {
        this.currentClassName = this.getClassName(className);
    }

    @Override
    public void classChanged(ClassInfo oldClassInfo, ClassInfo newClassInfo) throws DiffException {
        if (!this.isClassConsidered(oldClassInfo.getName())) {
            return;
        }
        this.differences.add(new Delta.Change(this.getClassName(oldClassInfo.getName()), oldClassInfo, newClassInfo));
    }

    @Override
    public void classDeprecated(ClassInfo oldClassInfo, ClassInfo newClassInfo) throws DiffException {
        if (!this.isClassConsidered(oldClassInfo.getName())) {
            return;
        }
        this.differences.add(new Delta.Deprecate(this.getClassName(oldClassInfo.getName()), oldClassInfo, newClassInfo));
    }

    @Override
    public void fieldChanged(FieldInfo oldFieldInfo, FieldInfo newFieldInfo) throws DiffException {
        if (!this.isClassConsidered(this.getCurrentClassName())) {
            return;
        }
        this.differences.add(new Delta.Change(this.getCurrentClassName(), oldFieldInfo, newFieldInfo));
    }

    @Override
    public void fieldDeprecated(FieldInfo oldFieldInfo, FieldInfo newFieldInfo) throws DiffException {
        if (!this.isClassConsidered(this.getCurrentClassName())) {
            return;
        }
        this.differences.add(new Delta.Deprecate(this.getCurrentClassName(), oldFieldInfo, newFieldInfo));
    }

    @Override
    public void methodChanged(MethodInfo oldMethodInfo, MethodInfo newMethodInfo) throws DiffException {
        if (!this.isClassConsidered(this.getCurrentClassName())) {
            return;
        }
        this.differences.add(new Delta.Change(this.getCurrentClassName(), oldMethodInfo, newMethodInfo));
    }

    @Override
    public void methodDeprecated(MethodInfo oldMethodInfo, MethodInfo newMethodInfo) throws DiffException {
        if (!this.isClassConsidered(this.getCurrentClassName())) {
            return;
        }
        this.differences.add(new Delta.Deprecate(this.getCurrentClassName(), oldMethodInfo, newMethodInfo));
    }

    @Override
    public void endClassChanged() throws DiffException {
    }

    @Override
    public void endChanged() throws DiffException {
    }

    @Override
    public void startRemoved() throws DiffException {
    }

    @Override
    public void classRemoved(ClassInfo classInfo) throws DiffException {
        if (!this.isClassConsidered(classInfo.getName())) {
            return;
        }
        this.differences.add(new Delta.Remove(this.getClassName(classInfo.getName()), classInfo));
    }

    @Override
    public void fieldRemoved(FieldInfo fieldInfo) throws DiffException {
        if (!this.isClassConsidered(this.getCurrentClassName())) {
            return;
        }
        this.differences.add(new Delta.Remove(this.getCurrentClassName(), fieldInfo));
    }

    @Override
    public void methodRemoved(MethodInfo methodInfo) throws DiffException {
        if (!this.isClassConsidered(this.getCurrentClassName())) {
            return;
        }
        this.differences.add(new Delta.Remove(this.getCurrentClassName(), methodInfo));
    }

    @Override
    public void endRemoved() throws DiffException {
    }

    protected boolean isClassConsidered(String className) {
        String fixedClassName = className.replace('.', '/');
        for (String exclude : this.excludes) {
            Matcher excludeMatcher;
            Pattern excludePattern;
            if (!this.excludesAreRegExp) {
                if (exclude.contains("/**/")) {
                    exclude = exclude.replaceAll("/\\*\\*/", "{0,1}**/");
                }
                if (exclude.contains("/*/")) {
                    exclude = exclude.replaceAll("/\\*/", "{0,1}*/{0,1}");
                }
                excludePattern = DifferenceAccumulatingHandler.simplifyRegularExpression(exclude, false);
            } else {
                excludePattern = Pattern.compile(exclude);
            }
            if (!(excludeMatcher = excludePattern.matcher(fixedClassName)).find()) continue;
            return false;
        }
        if (!this.includes.isEmpty()) {
            for (String include : this.includes) {
                Matcher includeMatcher;
                Pattern includePattern;
                if (!this.includesAreRegExp) {
                    if (include.contains("/**/")) {
                        include = include.replaceAll("/\\*\\*/", "{0,1}**/");
                    }
                    if (include.contains("/*/")) {
                        include = include.replaceAll("/\\*/", "{0,1}*/{0,1}");
                    }
                    includePattern = DifferenceAccumulatingHandler.simplifyRegularExpression(include, false);
                } else {
                    includePattern = Pattern.compile(include);
                }
                if (!(includeMatcher = includePattern.matcher(fixedClassName)).find()) continue;
                return false;
            }
        }
        return true;
    }

    private static Pattern simplifyRegularExpression(String regEx, boolean caseSensitive) {
        StringBuilder strBuild = new StringBuilder();
        Pattern p = Pattern.compile("\\{0,1\\}|\\*|\\?|[[^*^?^{^}]|^]+", 2);
        Matcher m = p.matcher(regEx);
        while (m.find()) {
            String token = m.group();
            if (token.equals("*") || token.equals("?")) {
                strBuild.append(token);
                continue;
            }
            if (token.equals("{0,1}")) {
                strBuild.append("/");
                strBuild.append(token);
                continue;
            }
            strBuild.append("\\Q").append(token).append("\\E");
        }
        strBuild.append("$");
        String result = strBuild.toString();
        result = result.replaceAll("(?<!\\*)\\*(?!\\*)", "[^/]*");
        result = result.replaceAll("[\\*][\\s]*[\\*]", ".\\*");
        result = result.replaceAll("\\?", ".");
        if (caseSensitive) {
            return Pattern.compile(result);
        }
        return Pattern.compile(result, 2);
    }

    public Delta getDelta() {
        return new Delta(this.differences);
    }
}

