/*
 * Decompiled with CFR 0.152.
 */
package org.semver.enforcer;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.metadata.ArtifactMetadataRetrievalException;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.enforcer.rule.api.EnforcerRule;
import org.apache.maven.enforcer.rule.api.EnforcerRuleException;
import org.apache.maven.enforcer.rule.api.EnforcerRuleHelper;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluationException;
import org.osjava.jardiff.DiffCriteria;
import org.osjava.jardiff.PublicDiffCriteria;
import org.osjava.jardiff.SimpleDiffCriteria;
import org.semver.Comparer;
import org.semver.Delta;
import org.semver.Dumper;
import org.semver.Version;

public abstract class AbstractEnforcerRule
implements EnforcerRule {
    private static final String JAR_ARTIFACT_TYPE = "jar";
    private static final String BUNDLE_ARTIFACT_TYPE = "bundle";
    private String previousVersion;
    private String[] includes;
    private String[] excludes;
    private boolean dumpDetails = false;
    private boolean publicOnly = false;

    private Set<String> extractFilters(String[] filtersAsStringArray) {
        if (filtersAsStringArray == null) {
            return Collections.emptySet();
        }
        return new HashSet<String>(Arrays.asList(filtersAsStringArray));
    }

    public void execute(EnforcerRuleHelper helper) throws EnforcerRuleException {
        Artifact previousArtifact;
        MavenProject project;
        try {
            project = (MavenProject)helper.evaluate("${project}");
        }
        catch (ExpressionEvaluationException e) {
            throw new EnforcerRuleException("Failed to access ${project} variable", (Exception)((Object)e));
        }
        String type = project.getArtifact().getType();
        if (!JAR_ARTIFACT_TYPE.equals(type) && !BUNDLE_ARTIFACT_TYPE.equals(type)) {
            helper.getLog().debug((CharSequence)"Skipping non jar or bundle artifact.");
            return;
        }
        Artifact currentArtifact = project.getArtifact();
        this.validateArtifact(currentArtifact);
        Version current = Version.parse((String)currentArtifact.getVersion());
        File currentJar = currentArtifact.getFile();
        try {
            String version;
            ArtifactRepository localRepository = (ArtifactRepository)helper.evaluate("${localRepository}");
            if (this.previousVersion != null) {
                version = this.previousVersion;
                helper.getLog().info((CharSequence)("Version specified as <" + version + ">"));
            } else {
                ArtifactMetadataSource artifactMetadataSource = (ArtifactMetadataSource)helper.getComponent(ArtifactMetadataSource.class);
                List<ArtifactVersion> availableVersions = this.getAvailableReleasedVersions(artifactMetadataSource, project, localRepository);
                List<ArtifactVersion> availablePreviousVersions = this.filterNonPreviousVersions(availableVersions, current);
                if (availablePreviousVersions.isEmpty()) {
                    helper.getLog().warn((CharSequence)"No previously released version. Backward compatibility check not performed.");
                    return;
                }
                version = availablePreviousVersions.iterator().next().toString();
                helper.getLog().info((CharSequence)("Version deduced as <" + version + "> (among all availables: " + availablePreviousVersions + ")"));
            }
            ArtifactFactory artifactFactory = (ArtifactFactory)helper.getComponent(ArtifactFactory.class);
            previousArtifact = artifactFactory.createArtifact(project.getGroupId(), project.getArtifactId(), version, null, type);
            ArtifactResolver resolver = (ArtifactResolver)helper.getComponent(ArtifactResolver.class);
            resolver.resolve(previousArtifact, project.getRemoteArtifactRepositories(), localRepository);
            this.validateArtifact(previousArtifact);
        }
        catch (Exception e) {
            helper.getLog().warn((CharSequence)"Exception while accessing artifacts; skipping check.", (Throwable)e);
            return;
        }
        Version previous = Version.parse((String)previousArtifact.getVersion());
        File previousJar = previousArtifact.getFile();
        helper.getLog().info((CharSequence)("Using <" + previousJar + "> as previous JAR"));
        helper.getLog().info((CharSequence)("Using <" + currentJar + "> as current JAR"));
        try {
            PublicDiffCriteria diffCriteria = this.publicOnly ? new PublicDiffCriteria() : new SimpleDiffCriteria();
            Comparer comparer = new Comparer((DiffCriteria)diffCriteria, previousJar, currentJar, this.extractFilters(this.includes), this.extractFilters(this.excludes));
            Delta delta = comparer.diff();
            this.enforce(helper, delta, previous, current);
        }
        catch (IOException e) {
            throw new EnforcerRuleException("Exception while checking compatibility: " + e.toString(), (Exception)e);
        }
    }

    protected abstract void enforce(EnforcerRuleHelper var1, Delta var2, Version var3, Version var4) throws EnforcerRuleException;

    protected final void fail(Delta delta, String message) throws EnforcerRuleException {
        if (this.dumpDetails) {
            Dumper.dump((Delta)delta);
        }
        throw new EnforcerRuleException(message);
    }

    protected final List<ArtifactVersion> getAvailableReleasedVersions(ArtifactMetadataSource artifactMetadataSource, MavenProject project, ArtifactRepository localRepository) throws ArtifactMetadataRetrievalException {
        List availableVersions = artifactMetadataSource.retrieveAvailableVersions(project.getArtifact(), localRepository, project.getRemoteArtifactRepositories());
        availableVersions.remove(new DefaultArtifactVersion(project.getArtifact().getVersion()));
        Iterator iterator = availableVersions.iterator();
        while (iterator.hasNext()) {
            ArtifactVersion artifactVersion = (ArtifactVersion)iterator.next();
            if (!Version.parse((String)artifactVersion.toString()).isSnapshot()) continue;
            iterator.remove();
        }
        Collections.sort(availableVersions);
        Collections.reverse(availableVersions);
        return availableVersions;
    }

    protected final List<ArtifactVersion> filterNonPreviousVersions(List<ArtifactVersion> availableVersions, Version version) {
        ArrayList<ArtifactVersion> versions = new ArrayList<ArtifactVersion>();
        for (ArtifactVersion artifactVersion : availableVersions) {
            if (version.compareTo(Version.parse((String)artifactVersion.toString())) <= 0) continue;
            versions.add(artifactVersion);
        }
        return versions;
    }

    private void validateArtifact(Artifact artifact) {
        if (!artifact.getFile().isFile()) {
            throw new IllegalArgumentException("<" + artifact.getFile() + "> is not a file");
        }
    }

    public boolean isCacheable() {
        return false;
    }

    public boolean isResultValid(EnforcerRule cachedRule) {
        return false;
    }

    public String getCacheId() {
        return "0";
    }
}

