/*
 * Decompiled with CFR 0.152.
 */
package org.ontoware.rdf2go.model.impl;

import java.util.Iterator;
import java.util.LinkedList;
import org.ontoware.rdf2go.exception.ModelRuntimeException;
import org.ontoware.rdf2go.model.Diff;
import org.ontoware.rdf2go.model.DiffReader;
import org.ontoware.rdf2go.model.ModelAddRemove;
import org.ontoware.rdf2go.model.Statement;
import org.ontoware.rdf2go.model.impl.AbstractModelWriter;
import org.ontoware.rdf2go.model.node.Node;
import org.ontoware.rdf2go.model.node.Resource;
import org.ontoware.rdf2go.model.node.URI;
import org.ontoware.rdf2go.model.node.impl.DatatypeLiteralImpl;
import org.ontoware.rdf2go.model.node.impl.LanguageTagLiteralImpl;
import org.ontoware.rdf2go.model.node.impl.PlainLiteralImpl;
import org.ontoware.rdf2go.model.node.impl.URIImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractModelAddRemove
extends AbstractModelWriter
implements ModelAddRemove {
    private static Logger log = LoggerFactory.getLogger(AbstractModelAddRemove.class);

    public void removeStatement(String subjectURIString, URI predicate, String literal) throws ModelRuntimeException {
        this.removeStatement((Resource)new URIImpl(subjectURIString), predicate, (Node)new PlainLiteralImpl(literal));
    }

    public void removeStatement(String subjectURIString, URI predicate, String literal, String languageTag) throws ModelRuntimeException {
        this.removeStatement((Resource)new URIImpl(subjectURIString), predicate, (Node)new LanguageTagLiteralImpl(literal, languageTag));
    }

    public void removeStatement(String subjectURIString, URI predicate, String literal, URI datatypeURI) throws ModelRuntimeException {
        this.removeStatement((Resource)new URIImpl(subjectURIString), predicate, (Node)new DatatypeLiteralImpl(literal, datatypeURI));
    }

    public void removeStatement(Resource subject, URI predicate, String literal) throws ModelRuntimeException {
        this.removeStatement(subject, predicate, (Node)new PlainLiteralImpl(literal));
    }

    public void removeStatement(Resource subject, URI predicate, String literal, String languageTag) throws ModelRuntimeException {
        this.removeStatement(subject, predicate, (Node)new LanguageTagLiteralImpl(literal, languageTag));
    }

    public void removeStatement(Resource subject, URI predicate, String literal, URI datatypeURI) throws ModelRuntimeException {
        this.removeStatement(subject, predicate, (Node)new DatatypeLiteralImpl(literal, datatypeURI));
    }

    public void removeStatement(Statement statement) throws ModelRuntimeException {
        this.removeStatement(statement.getSubject(), statement.getPredicate(), statement.getObject());
    }

    public void removeAll(Iterator<? extends Statement> other) throws ModelRuntimeException {
        while (other.hasNext()) {
            Statement stmt = other.next();
            this.removeStatement(stmt);
        }
    }

    public void removeAll() throws ModelRuntimeException {
        LinkedList<Statement> temp = new LinkedList<Statement>();
        Iterator i$ = this.iterator();
        while (i$.hasNext()) {
            Statement statement = (Statement)i$.next();
            temp.add(statement);
        }
        for (Statement s : temp) {
            this.removeStatement(s);
        }
    }

    public void update(DiffReader diff) throws ModelRuntimeException {
        this.removeAll(diff.getRemoved().iterator());
        this.addAll(diff.getAdded().iterator());
    }

    @Deprecated
    public void update(Diff diff) throws ModelRuntimeException {
        this.removeAll(diff.getRemoved().iterator());
        this.addAll(diff.getAdded().iterator());
    }

    @Override
    public abstract void addStatement(Resource var1, URI var2, Node var3) throws ModelRuntimeException;

    public abstract void removeStatement(Resource var1, URI var2, Node var3) throws ModelRuntimeException;
}

