/*
 * Decompiled with CFR 0.152.
 */
package org.ontoware.rdf2go.model.impl;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.ontoware.rdf2go.exception.ModelRuntimeException;
import org.ontoware.rdf2go.model.DiffReader;
import org.ontoware.rdf2go.model.Model;
import org.ontoware.rdf2go.model.ModelChangedListener;
import org.ontoware.rdf2go.model.NotifyingModel;
import org.ontoware.rdf2go.model.Statement;
import org.ontoware.rdf2go.model.TriplePattern;
import org.ontoware.rdf2go.model.impl.DelegatingModel;
import org.ontoware.rdf2go.model.impl.ModelAddRemoveMemoryImpl;
import org.ontoware.rdf2go.model.node.Node;
import org.ontoware.rdf2go.model.node.NodeOrVariable;
import org.ontoware.rdf2go.model.node.Resource;
import org.ontoware.rdf2go.model.node.ResourceOrVariable;
import org.ontoware.rdf2go.model.node.URI;
import org.ontoware.rdf2go.model.node.UriOrVariable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NotifyingModelLayer
extends DelegatingModel
implements NotifyingModel {
    private Map<ModelChangedListener, TriplePattern> modelChangeListener = new HashMap<ModelChangedListener, TriplePattern>();

    public NotifyingModelLayer(Model model) {
        super(model);
    }

    @Override
    public void addAll(Iterator<? extends Statement> other) throws ModelRuntimeException {
        while (other.hasNext()) {
            this.addStatement(other.next());
        }
    }

    @Override
    public void addStatement(Resource subject, URI predicate, Node object) throws ModelRuntimeException {
        this.addStatement(super.getDelegatedModel().createStatement(subject, predicate, object));
    }

    @Override
    public void addStatement(Resource subject, URI predicate, String literal, String languageTag) throws ModelRuntimeException {
        this.addStatement(this.getDelegatedModel().createStatement(subject, predicate, (Node)this.getDelegatedModel().createLanguageTagLiteral(literal, languageTag)));
    }

    @Override
    public void addStatement(Resource subject, URI predicate, String literal, URI datatypeURI) throws ModelRuntimeException {
        this.addStatement(subject, predicate, (Node)this.getDelegatedModel().createDatatypeLiteral(literal, datatypeURI));
    }

    @Override
    public void addStatement(Resource subject, URI predicate, String literal) throws ModelRuntimeException {
        this.addStatement(this.getDelegatedModel().createStatement(subject, predicate, (Node)this.getDelegatedModel().createPlainLiteral(literal)));
    }

    @Override
    public void addStatement(Statement statement) throws ModelRuntimeException {
        for (ModelChangedListener listener : this.modelChangeListener.keySet()) {
            TriplePattern pattern = this.modelChangeListener.get(listener);
            if (pattern != null && !pattern.matches(statement)) continue;
            listener.addedStatement(statement);
        }
        this.getDelegatedModel().addStatement(statement);
    }

    @Override
    public void addStatement(String subjectURIString, URI predicate, String literal, String languageTag) throws ModelRuntimeException {
        this.addStatement(this.getDelegatedModel().createStatement((Resource)this.getDelegatedModel().createURI(subjectURIString), predicate, (Node)this.getDelegatedModel().createLanguageTagLiteral(literal, languageTag)));
    }

    @Override
    public void addStatement(String subjectURIString, URI predicate, String literal, URI datatypeURI) throws ModelRuntimeException {
        this.addStatement(this.getDelegatedModel().createStatement((Resource)this.getDelegatedModel().createURI(subjectURIString), predicate, (Node)this.getDelegatedModel().createDatatypeLiteral(literal, datatypeURI)));
    }

    @Override
    public void addStatement(String subjectURIString, URI predicate, String literal) throws ModelRuntimeException {
        this.addStatement(this.getDelegatedModel().createStatement((Resource)this.getDelegatedModel().createURI(subjectURIString), predicate, (Node)this.getDelegatedModel().createPlainLiteral(literal)));
    }

    @Override
    public void removeAll(Iterator<? extends Statement> other) throws ModelRuntimeException {
        while (other.hasNext()) {
            this.removeStatement(other.next());
        }
    }

    @Override
    public void removeStatement(Resource subject, URI predicate, Node object) throws ModelRuntimeException {
        this.removeStatement(this.getDelegatedModel().createStatement(subject, predicate, object));
    }

    @Override
    public void removeStatement(Resource subject, URI predicate, String literal, String languageTag) throws ModelRuntimeException {
        this.removeStatement(this.getDelegatedModel().createStatement(subject, predicate, (Node)this.getDelegatedModel().createLanguageTagLiteral(literal, languageTag)));
    }

    @Override
    public void removeStatement(Resource subject, URI predicate, String literal, URI datatypeURI) throws ModelRuntimeException {
        this.removeStatement(subject, predicate, (Node)this.getDelegatedModel().createDatatypeLiteral(literal, datatypeURI));
    }

    @Override
    public void removeStatement(Resource subject, URI predicate, String literal) throws ModelRuntimeException {
        this.removeStatement(this.getDelegatedModel().createStatement(subject, predicate, (Node)this.getDelegatedModel().createPlainLiteral(literal)));
    }

    @Override
    public void removeStatement(Statement statement) throws ModelRuntimeException {
        for (ModelChangedListener listener : this.modelChangeListener.keySet()) {
            TriplePattern pattern = this.modelChangeListener.get(listener);
            if (pattern != null && !pattern.matches(statement)) continue;
            listener.removedStatement(statement);
        }
        this.getDelegatedModel().removeStatement(statement);
    }

    @Override
    public void removeStatement(String subjectURIString, URI predicate, String literal, String languageTag) throws ModelRuntimeException {
        this.removeStatement(this.getDelegatedModel().createStatement((Resource)this.getDelegatedModel().createURI(subjectURIString), predicate, (Node)this.getDelegatedModel().createLanguageTagLiteral(literal, languageTag)));
    }

    @Override
    public void removeStatement(String subjectURIString, URI predicate, String literal, URI datatypeURI) throws ModelRuntimeException {
        this.removeStatement(this.getDelegatedModel().createStatement((Resource)this.getDelegatedModel().createURI(subjectURIString), predicate, (Node)this.getDelegatedModel().createDatatypeLiteral(literal, datatypeURI)));
    }

    @Override
    public void removeStatement(String subjectURIString, URI predicate, String literal) throws ModelRuntimeException {
        this.removeStatement(this.getDelegatedModel().createStatement((Resource)this.getDelegatedModel().createURI(subjectURIString), predicate, (Node)this.getDelegatedModel().createPlainLiteral(literal)));
    }

    @Override
    public void removeStatements(ResourceOrVariable subject, UriOrVariable predicate, NodeOrVariable object) throws ModelRuntimeException {
        ModelAddRemoveMemoryImpl toBeRemoved = new ModelAddRemoveMemoryImpl();
        toBeRemoved.addAll((Iterator<? extends Statement>)this.findStatements(subject, predicate, object));
        this.removeAll((Iterator<? extends Statement>)toBeRemoved.iterator());
        this.getDelegatedModel().removeAll(toBeRemoved.iterator());
    }

    @Override
    public void update(DiffReader diff) throws ModelRuntimeException {
        for (ModelChangedListener listener : this.modelChangeListener.keySet()) {
            listener.performedUpdate(diff);
        }
        this.getDelegatedModel().update(diff);
    }

    public void addModelChangedListener(ModelChangedListener listener, TriplePattern pattern) {
        this.modelChangeListener.put(listener, pattern);
    }

    public void addModelChangedListener(ModelChangedListener listener) {
        this.modelChangeListener.put(listener, null);
    }

    public void removeModelChangedListener(ModelChangedListener listener) {
        this.modelChangeListener.remove(listener);
    }
}

