/*
 * Decompiled with CFR 0.152.
 */
package org.ontoware.rdf2go.model.node.impl;

import org.ontoware.rdf2go.model.node.DatatypeLiteral;
import org.ontoware.rdf2go.model.node.LanguageTagLiteral;
import org.ontoware.rdf2go.model.node.Node;
import org.ontoware.rdf2go.model.node.URI;
import org.ontoware.rdf2go.model.node.impl.LiteralImpl;
import org.ontoware.rdf2go.model.node.impl.NodeUtils;
import org.ontoware.rdf2go.model.node.impl.URIImpl;
import org.ontoware.rdf2go.vocabulary.XSD;

public class DatatypeLiteralImpl
extends LiteralImpl
implements DatatypeLiteral {
    private URI datatype;
    private String value;

    public DatatypeLiteralImpl(String value, URI datatype) {
        assert (value != null);
        assert (datatype != null);
        this.datatype = datatype;
        this.value = value;
    }

    public DatatypeLiteralImpl(String turtleEncoded) {
        assert (turtleEncoded.contains("^^"));
        int i = turtleEncoded.lastIndexOf("^^");
        this.value = turtleEncoded.substring(0, i);
        this.datatype = new URIImpl(turtleEncoded.substring(i + 2));
    }

    public URI getDatatype() {
        return this.datatype;
    }

    public String getValue() {
        return this.value;
    }

    public boolean equals(Object o) {
        return o instanceof DatatypeLiteralImpl && this.getValue().equals(((DatatypeLiteralImpl)o).getValue()) && this.getDatatype().equals(((DatatypeLiteralImpl)o).getDatatype());
    }

    public String toString() {
        return this.getValue() + "^^" + this.getDatatype();
    }

    public int asInt() throws ClassCastException, NumberFormatException {
        if (this.getDatatype().equals(XSD._int) || this.getDatatype().equals(XSD._nonPositiveInteger) || this.getDatatype().equals(XSD._long) || this.getDatatype().equals(XSD._nonNegativeInteger) || this.getDatatype().equals(XSD._negativeInteger) || this.getDatatype().equals(XSD._integer) || this.getDatatype().equals(XSD._short) || this.getDatatype().equals(XSD._byte) || this.getDatatype().equals(XSD._unsignedLong) || this.getDatatype().equals(XSD._unsignedByte) || this.getDatatype().equals(XSD._unsignedInt) || this.getDatatype().equals(XSD._unsignedShort) || this.getDatatype().equals(XSD._positiveInteger)) {
            return Integer.parseInt(this.getValue());
        }
        throw new ClassCastException("Datatype is " + this.getDatatype() + " which is not derrived from xsd:integer");
    }

    public boolean asBoolean() throws ClassCastException {
        return Boolean.parseBoolean(this.getValue());
    }

    public DatatypeLiteral asDatatypeLiteral() throws ClassCastException {
        return this;
    }

    public LanguageTagLiteral asLanguageTagLiteral() throws ClassCastException {
        throw new ClassCastException("Cannot call this on a DatatypeLiteral");
    }

    public int hashCode() {
        return this.datatype.hashCode() + this.value.hashCode();
    }

    public int compareTo(Node other) {
        if (other instanceof DatatypeLiteral) {
            DatatypeLiteral oLit = (DatatypeLiteral)other;
            int diff = this.getValue().compareTo(oLit.getValue());
            if (diff != 0) {
                return diff;
            }
            return this.getDatatype().compareTo((Object)oLit.getDatatype());
        }
        return NodeUtils.compareByType((Node)this, (Node)other);
    }

    public String toSPARQL() {
        return "'''" + DatatypeLiteralImpl.sparqlEncode(this.value) + "'''^^<" + this.datatype + ">";
    }
}

