/*
 * Decompiled with CFR 0.152.
 */
package org.seqdoop.hadoop_bam;

import htsjdk.samtools.FileTruncatedException;
import htsjdk.samtools.seekablestream.SeekableStream;
import htsjdk.samtools.util.BlockCompressedInputStream;
import htsjdk.samtools.util.RuntimeEOFException;
import htsjdk.tribble.TribbleException;
import htsjdk.tribble.readers.PositionalBufferedStream;
import htsjdk.variant.bcf2.BCF2Codec;
import htsjdk.variant.vcf.VCFHeader;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.util.GenericOptionsParser;
import org.seqdoop.hadoop_bam.util.SeekableArrayStream;
import org.seqdoop.hadoop_bam.util.WrapSeekable;

public class BCFSplitGuesser {
    private InputStream cin;
    private SeekableStream inFile;
    private SeekableStream in;
    private final boolean bgzf;
    private final BCF2Codec bcfCodec = new BCF2Codec();
    private final ByteBuffer buf;
    private final int contigDictionaryLength;
    private final int genotypeSampleCount;
    private static final int UNCOMPRESSED_BYTES_NEEDED = 524288;
    private static final byte BGZF_BLOCKS_NEEDED_FOR_GUESS = 2;
    private static final int BGZF_MAX_BYTES_READ = 196604;
    private static final int BGZF_MAGIC = 67668767;
    private static final int BGZF_MAGIC_SUB = 148290;
    private static final int BGZF_SUB_SIZE = 6;
    private static final int SHORTEST_POSSIBLE_BCF_RECORD = 33;

    public BCFSplitGuesser(SeekableStream ss) throws IOException {
        this(ss, (InputStream)ss);
    }

    public BCFSplitGuesser(SeekableStream ss, InputStream headerStream) throws IOException {
        this.inFile = ss;
        this.buf = ByteBuffer.allocate(8);
        this.buf.order(ByteOrder.LITTLE_ENDIAN);
        BufferedInputStream bInFile = new BufferedInputStream((InputStream)this.inFile);
        this.bgzf = BlockCompressedInputStream.isValidFile((InputStream)bInFile);
        if (this.bgzf) {
            bInFile = new BlockCompressedInputStream((InputStream)bInFile);
        }
        VCFHeader header = (VCFHeader)this.bcfCodec.readHeader(new PositionalBufferedStream((InputStream)bInFile)).getHeaderValue();
        this.contigDictionaryLength = header.getContigLines().size();
        this.genotypeSampleCount = header.getNGenotypeSamples();
    }

    public boolean isBGZF() {
        return this.bgzf;
    }

    private void cinSeek(long virt) throws IOException {
        if (this.bgzf) {
            ((BlockCompressedInputStream)this.cin).seek(virt);
        } else {
            ((SeekableStream)this.cin).seek(virt);
        }
    }

    public long guessNextBCFRecordStart(long beg, long end) throws IOException {
        int firstBGZFEnd;
        int r;
        byte[] arr = new byte[this.bgzf ? 196604 : 524288];
        this.inFile.seek(beg);
        int totalRead = 0;
        for (int left = Math.min((int)(end - beg), arr.length); left > 0 && (r = this.inFile.read(arr, totalRead, left)) >= 0; left -= r) {
            totalRead += r;
        }
        arr = Arrays.copyOf(arr, totalRead);
        this.in = new SeekableArrayStream(arr);
        if (this.bgzf) {
            firstBGZFEnd = Math.min((int)(end - beg), 65535);
            BlockCompressedInputStream bgzfStream = new BlockCompressedInputStream(this.in);
            bgzfStream.setCheckCrcs(true);
            this.cin = bgzfStream;
        } else {
            this.cin = this.in;
            firstBGZFEnd = 0;
        }
        int cp = 0;
        while (true) {
            block21: {
                int up0;
                int blockLen;
                long cp0Virt;
                int cp0;
                if (this.bgzf) {
                    PosSize psz = this.guessNextBGZFPos(cp, firstBGZFEnd);
                    if (psz == null) break;
                    cp0 = cp = psz.pos;
                    cp0Virt = (long)cp0 << 16;
                    try {
                        this.cinSeek(cp0Virt);
                    }
                    catch (Throwable e) {
                        break block21;
                    }
                    blockLen = psz.size;
                } else {
                    cp0 = 0;
                    cp0Virt = 0L;
                    blockLen = Math.max(arr.length, 524288);
                }
                int up = 0;
                while ((up0 = (up = this.guessNextBCFPos(cp0Virt, up, blockLen))) >= 0) {
                    block23: {
                        block22: {
                            this.cinSeek(cp0Virt | (long)up0);
                            PositionalBufferedStream pbIn = new PositionalBufferedStream(this.cin);
                            boolean decodedAny = false;
                            try {
                                if (this.bgzf) {
                                    int b = 0;
                                    int prevCP = cp0;
                                    while (b < 2 && pbIn.peek() != -1) {
                                        this.bcfCodec.decode(pbIn);
                                        decodedAny = true;
                                        int cp2 = (int)(((BlockCompressedInputStream)this.cin).getFilePointer() >>> 16);
                                        if (cp2 == prevCP) continue;
                                        assert (cp2 > prevCP);
                                        cp = cp2;
                                        b = (byte)(b + 1);
                                    }
                                    if (b >= 2) break block22;
                                    assert (arr.length < 196604);
                                    if (decodedAny) break block22;
                                    break block23;
                                }
                                while (pbIn.getPosition() - (long)up0 < 524288L && pbIn.peek() != -1) {
                                    this.bcfCodec.decode(pbIn);
                                    decodedAny = true;
                                }
                                if (pbIn.getPosition() - (long)up0 >= 524288L) break block22;
                                assert (arr.length < 524288);
                                if (!decodedAny) {
                                }
                                break block22;
                            }
                            catch (FileTruncatedException e) {
                            }
                            catch (OutOfMemoryError e) {
                            }
                            catch (RuntimeEOFException e) {
                            }
                            catch (TribbleException e) {
                                if (!decodedAny) break block23;
                                if (pbIn.peek() == -1) break block22;
                            }
                            break block23;
                        }
                        return this.bgzf ? beg + (long)cp0 << 16 | (long)up0 : beg + (long)up0;
                    }
                    ++up;
                }
                if (!this.bgzf) break;
            }
            ++cp;
        }
        return end;
    }

    private PosSize guessNextBGZFPos(int p, int end) {
        try {
            while (true) {
                this.in.seek((long)p);
                this.in.read(this.buf.array(), 0, 4);
                int n = this.buf.getInt(0);
                if (n != 67668767) {
                    p = n >>> 8 == 559903 ? ++p : (n >>> 16 == 35615 ? (p += 2) : (p += 3));
                    if (p < end) continue;
                    return null;
                }
                int p0 = p;
                this.in.seek((long)(p += 10));
                this.in.read(this.buf.array(), 0, 2);
                int xlen = this.getUShort(0);
                int subEnd = (p += 2) + xlen;
                while (p < subEnd) {
                    this.in.read(this.buf.array(), 0, 4);
                    if (this.buf.getInt(0) != 148290) {
                        this.in.seek((long)(p += 4 + this.getUShort(2)));
                        continue;
                    }
                    this.in.read(this.buf.array(), 0, 2);
                    int bsize = this.getUShort(0);
                    p += 6;
                    while (p < subEnd) {
                        this.in.seek((long)p);
                        this.in.read(this.buf.array(), 0, 4);
                        p += 4 + this.getUShort(2);
                    }
                    if (p != subEnd) break;
                    this.in.seek((long)(p += bsize - xlen - 19 + 4));
                    this.in.read(this.buf.array(), 0, 4);
                    return new PosSize(p0, this.buf.getInt(0));
                }
                p = p0 + 4;
            }
        }
        catch (IOException e) {
            return null;
        }
    }

    private int guessNextBCFPos(long cpVirt, int up, int cSize) {
        try {
            while (up + 33 < cSize) {
                block10: {
                    block11: {
                        long idLen;
                        this.cinSeek(cpVirt | (long)up);
                        this.cin.read(this.buf.array(), 0, 8);
                        long sharedLen = this.getUInt(0);
                        long indivLen = this.getUInt(4);
                        if (sharedLen + indivLen < 33L) break block10;
                        this.cinSeek(cpVirt | (long)(up + 8));
                        this.cin.read(this.buf.array(), 0, 8);
                        int chrom = this.buf.getInt(0);
                        int pos = this.buf.getInt(4);
                        if (chrom < 0 || chrom >= this.contigDictionaryLength || pos < 0) break block10;
                        this.cinSeek(cpVirt | (long)(up + 24));
                        this.cin.read(this.buf.array(), 0, 4);
                        int alleleInfo = this.buf.getInt(0);
                        int alleleCount = alleleInfo >> 16;
                        int infoCount = alleleInfo & 0xFFFF;
                        if (alleleCount < 0 || infoCount < 0) break block10;
                        this.cinSeek(cpVirt | (long)(up + 28));
                        this.cin.read(this.buf.array(), 0, 1);
                        short nSamples = this.getUByte(0);
                        if (nSamples != this.genotypeSampleCount) break block10;
                        this.cinSeek(cpVirt | (long)(up + 32));
                        this.cin.read(this.buf.array(), 0, 6);
                        byte idType = this.buf.get(0);
                        if ((idType & 0xF) != 7) break block10;
                        if ((idType & 0xF0) != 240) break block11;
                        byte idLenType = this.buf.get(1);
                        switch (idLenType & 0xF) {
                            case 1: {
                                idLen = this.getUByte(2);
                                break;
                            }
                            case 2: {
                                idLen = this.getUShort(2);
                                break;
                            }
                            case 3: {
                                idLen = this.getUInt(2);
                                break;
                            }
                            default: {
                                break block10;
                            }
                        }
                        if (idLen < 15L || idLen > sharedLen - (long)(32 + alleleCount + infoCount * 2)) break block10;
                    }
                    return up;
                }
                ++up;
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        return -1;
    }

    private long getUInt(int idx) {
        return (long)this.buf.getInt(idx) & 0xFFFFFFFFFFFFFFFFL;
    }

    private int getUShort(int idx) {
        return this.buf.getShort(idx) & 0xFFFF;
    }

    private short getUByte(int idx) {
        return (short)((short)this.buf.get(idx) & 0xFF);
    }

    public static void main(String[] args) throws IOException {
        long end;
        GenericOptionsParser parser;
        try {
            parser = new GenericOptionsParser(args);
        }
        catch (Exception e) {
            System.err.printf("Error in Hadoop arguments: %s\n", e.getMessage());
            System.exit(1);
            return;
        }
        args = parser.getRemainingArgs();
        Configuration conf = parser.getConfiguration();
        long beg = 0L;
        if (args.length < 2 || args.length > 3) {
            System.err.println("Usage: BCFSplitGuesser path-or-uri header-path-or-uri [beg]");
            System.exit(2);
        }
        try {
            if (args.length > 2) {
                beg = Long.decode(args[2]);
            }
        }
        catch (NumberFormatException e) {
            System.err.println("Invalid beg offset.");
            if (e.getMessage() != null) {
                System.err.println(e.getMessage());
            }
            System.exit(2);
        }
        WrapSeekable<FSDataInputStream> ss = WrapSeekable.openPath(conf, new Path(args[0]));
        WrapSeekable<FSDataInputStream> hs = WrapSeekable.openPath(conf, new Path(args[1]));
        BCFSplitGuesser guesser = new BCFSplitGuesser(ss, (InputStream)((Object)hs));
        if (guesser.isBGZF()) {
            end = beg + 196604L;
            System.out.printf("This looks like a BGZF-compressed BCF file.\nWill look for a BGZF block within: [%1$#x,%2$#x) = [%1$d,%2$d)\nWill then verify BCF data within:  [%1$#x,%3$#x) = [%1$d,%3$d)\n", beg, beg + 65535L, end);
        } else {
            end = beg + 524288L;
            System.out.printf("This looks like an uncompressed BCF file.\nWill look for a BCF record within: [%1$#x,%2$#x) = [%1$d,%2$d)\nAnd then will verify all following data in that range.\n", beg, end);
        }
        long g = guesser.guessNextBCFRecordStart(beg, end);
        ss.close();
        if (g == end) {
            System.out.println("Didn't find any acceptable BCF record in any BGZF block.");
            System.exit(1);
        }
        if (guesser.isBGZF()) {
            System.out.printf("Accepted BGZF block at offset %1$#x (%1$d).\nAccepted BCF record at offset %2$#x (%2$d) therein.\n", g >> 16, g & 0xFFFFL);
        } else {
            System.out.printf("Accepted BCF record at offset %1$#x (%1$d).\n", g);
        }
    }

    private static class PosSize {
        public int pos;
        public int size;

        public PosSize(int p, int s) {
            this.pos = p;
            this.size = s;
        }
    }
}

