/*
 * Decompiled with CFR 0.152.
 */
package org.seqdoop.hadoop_bam;

import java.io.IOException;
import java.io.InputStream;
import org.apache.hadoop.fs.Path;

public enum SAMFormat {
    SAM,
    BAM;


    public static SAMFormat inferFromFilePath(Path path) {
        return SAMFormat.inferFromFilePath(path.getName());
    }

    public static SAMFormat inferFromFilePath(String name) {
        if (name.endsWith(".bam")) {
            return BAM;
        }
        if (name.endsWith(".sam")) {
            return SAM;
        }
        return null;
    }

    public static SAMFormat inferFromData(InputStream in) throws IOException {
        byte b = (byte)in.read();
        in.close();
        switch (b) {
            case 31: {
                return BAM;
            }
            case 64: {
                return SAM;
            }
        }
        return null;
    }
}

