/*
 * Decompiled with CFR 0.152.
 */
package org.seqdoop.hadoop_bam.cli.plugins;

import hbparquet.hadoop.util.ContextUtil;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.seqdoop.hadoop_bam.KeyIgnoringVCFOutputFormat;
import org.seqdoop.hadoop_bam.VariantContextWritable;
import org.seqdoop.hadoop_bam.cli.Utils;

final class SortOutputFormat<K>
extends FileOutputFormat<K, VariantContextWritable> {
    public static final String INPUT_PATH_PROP = "hadoopbam.vcfsort.inpath";
    private KeyIgnoringVCFOutputFormat<K> baseOF;

    SortOutputFormat() {
    }

    private void initBaseOF(Configuration conf) {
        if (this.baseOF == null) {
            this.baseOF = new KeyIgnoringVCFOutputFormat(conf);
        }
    }

    public RecordWriter<K, VariantContextWritable> getRecordWriter(TaskAttemptContext context) throws IOException {
        Configuration conf = ContextUtil.getConfiguration((JobContext)context);
        this.initBaseOF(conf);
        if (this.baseOF.getHeader() == null) {
            Path p = new Path(conf.get(INPUT_PATH_PROP));
            this.baseOF.readHeaderFrom(p, p.getFileSystem(conf));
        }
        return this.baseOF.getRecordWriter(context, this.getDefaultWorkFile(context, ""));
    }

    public Path getDefaultWorkFile(TaskAttemptContext ctx, String ext) throws IOException {
        this.initBaseOF(ContextUtil.getConfiguration((JobContext)ctx));
        return Utils.getMergeableWorkFile(this.baseOF.getDefaultWorkFile(ctx, ext).getParent(), "", "", ctx, ext);
    }

    public void checkOutputSpecs(JobContext job) {
    }
}

