/*
 * Decompiled with CFR 0.152.
 */
package org.seqdoop.hadoop_bam.cli.plugins;

import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMFileReader;
import htsjdk.samtools.SAMFileWriterImpl;
import htsjdk.samtools.SAMFormatException;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMRecordIterator;
import htsjdk.samtools.SAMSequenceRecord;
import htsjdk.samtools.SAMTextWriter;
import htsjdk.samtools.ValidationStringency;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.Path;
import org.seqdoop.hadoop_bam.SAMFormat;
import org.seqdoop.hadoop_bam.cli.CLIPlugin;
import org.seqdoop.hadoop_bam.cli.Utils;
import org.seqdoop.hadoop_bam.custom.jargs.gnu.CmdLineParser;
import org.seqdoop.hadoop_bam.util.Pair;
import org.seqdoop.hadoop_bam.util.WrapSeekable;

public final class View
extends CLIPlugin {
    private static final List<Pair<CmdLineParser.Option, String>> optionDescs = new ArrayList<Pair<CmdLineParser.Option, String>>();
    private static final CmdLineParser.Option headerOnlyOpt = new CmdLineParser.Option.BooleanOption('H', "header-only");
    private static final CmdLineParser.Option formatOpt = new CmdLineParser.Option.StringOption('F', "format=FMT");
    private static final CmdLineParser.Option stringencyOpt = new CmdLineParser.Option.StringOption("validation-stringency=S");

    public View() {
        super("view", "SAM and BAM viewing", "1.2", "PATH [regions...]", optionDescs, "Reads the BAM or SAM file in PATH and, by default, outputs it in SAM format. If any number of regions is given, only the alignments overlapping with those regions are output. Then an index is also required, expected at PATH.bai by default.\n\nRegions can be given as only reference sequence names or indices like 'chr1', or with position ranges as well like 'chr1:100-200'. These coordinates are 1-based, with 0 representing the start or end of the sequence.");
    }

    @Override
    protected int run(CmdLineParser parser) {
        SAMTextWriter writer;
        SAMFileHeader header;
        SAMFileReader reader;
        List<String> args = parser.getRemainingArgs();
        if (args.isEmpty()) {
            System.err.println("view :: PATH not given.");
            return 3;
        }
        Utils.toStringency(parser.getOptionValue(stringencyOpt, ValidationStringency.DEFAULT_STRINGENCY.toString()), "view");
        String path = args.get(0);
        List<String> regions = args.subList(1, args.size());
        boolean headerOnly = parser.getBoolean(headerOnlyOpt);
        try {
            WrapSeekable<FSDataInputStream> idx;
            Path p = new Path(path);
            try {
                idx = WrapSeekable.openPath(this.getConf(), p.suffix(".bai"));
            }
            catch (Exception e) {
                idx = null;
            }
            WrapSeekable<FSDataInputStream> sam = WrapSeekable.openPath(this.getConf(), p);
            reader = idx == null ? new SAMFileReader(sam, false) : new SAMFileReader(sam, idx, false);
        }
        catch (Exception e) {
            System.err.printf("view :: Could not open '%s': %s\n", path, e.getMessage());
            return 4;
        }
        reader.setValidationStringency(ValidationStringency.SILENT);
        try {
            header = reader.getFileHeader();
        }
        catch (SAMFormatException e) {
            System.err.printf("view :: Could not parse '%s': %s\n", path, e.getMessage());
            return 4;
        }
        String fmt = (String)parser.getOptionValue(formatOpt);
        SAMFormat format = fmt == null ? SAMFormat.SAM : SAMFormat.valueOf(fmt.toUpperCase(Locale.ENGLISH));
        switch (format) {
            case BAM: {
                System.err.println("BAM output inside view no longer supported");
                return 1;
            }
            case SAM: {
                writer = new SAMTextWriter((OutputStream)System.out);
                break;
            }
            default: {
                writer = null;
                assert (false);
                break;
            }
        }
        writer.setSortOrder(header.getSortOrder(), true);
        writer.setHeader(header);
        if (regions.isEmpty() || headerOnly) {
            if (!headerOnly && !this.writeIterator((SAMFileWriterImpl)writer, reader.iterator(), path)) {
                return 4;
            }
            writer.close();
            return 0;
        }
        if (!reader.isBinary()) {
            System.err.println("view :: Cannot output regions from SAM file");
            return 4;
        }
        if (!reader.hasIndex()) {
            System.err.println("view :: Cannot output regions from BAM file lacking an index");
            return 4;
        }
        reader.enableIndexCaching(true);
        boolean errors = false;
        for (String region : regions) {
            SAMSequenceRecord ref;
            int end;
            int beg;
            StringTokenizer st = new StringTokenizer(region, ":-");
            String refStr = st.nextToken();
            if (st.hasMoreTokens()) {
                beg = this.parseCoordinate(st.nextToken());
                int n = end = st.hasMoreTokens() ? this.parseCoordinate(st.nextToken()) : -1;
                if (beg < 0 || end < 0) {
                    errors = true;
                    continue;
                }
                if (end < beg) {
                    System.err.printf("view :: Invalid range, cannot end before start: '%d-%d'\n", beg, end);
                    errors = true;
                    continue;
                }
            } else {
                end = 0;
                beg = 0;
            }
            if ((ref = header.getSequence(refStr)) == null) {
                try {
                    ref = header.getSequence(Integer.parseInt(refStr));
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
            if (ref == null) {
                System.err.printf("view :: Not a valid sequence name or index: '%s'\n", refStr);
                errors = true;
                continue;
            }
            SAMRecordIterator it = reader.queryOverlapping(ref.getSequenceName(), beg, end);
            if (this.writeIterator((SAMFileWriterImpl)writer, it, path)) continue;
            return 4;
        }
        writer.close();
        return errors ? 5 : 0;
    }

    private boolean writeIterator(SAMFileWriterImpl writer, SAMRecordIterator it, String path) {
        try {
            while (it.hasNext()) {
                writer.addAlignment((SAMRecord)it.next());
            }
            return true;
        }
        catch (SAMFormatException e) {
            writer.close();
            System.err.printf("view :: Could not parse '%s': %s\n", path, e.getMessage());
            return false;
        }
    }

    private int parseCoordinate(String s) {
        int c;
        try {
            c = Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            c = -1;
        }
        if (c < 0) {
            System.err.printf("view :: Not a valid coordinate: '%s'\n", s);
        }
        return c;
    }

    static {
        optionDescs.add(new Pair<CmdLineParser.Option, String>(headerOnlyOpt, "print header only"));
        optionDescs.add(new Pair<CmdLineParser.Option, String>(formatOpt, "select the output format based on FMT: SAM or BAM"));
        optionDescs.add(new Pair<CmdLineParser.Option, String>(stringencyOpt, Utils.getStringencyOptHelp()));
    }
}

