/*
 * Decompiled with CFR 0.152.
 */
package org.seqdoop.hadoop_bam.cli.plugins.chipster;

import hbparquet.hadoop.util.ContextUtil;
import htsjdk.samtools.util.BlockCompressedInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;
import org.apache.hadoop.util.LineReader;
import org.seqdoop.hadoop_bam.util.WrapSeekable;

final class BlockCompressedLineRecordReader
extends RecordReader<NullWritable, Text> {
    private long start;
    private long pos;
    private long end;
    private BlockCompressedInputStream bin;
    private LineReader in;
    private int maxLineLength;
    private Text value = new Text();

    BlockCompressedLineRecordReader() {
    }

    public void initialize(InputSplit genericSplit, TaskAttemptContext context) throws IOException {
        Configuration conf = ContextUtil.getConfiguration((JobContext)context);
        this.maxLineLength = conf.getInt("mapred.linerecordreader.maxlength", Integer.MAX_VALUE);
        FileSplit split = (FileSplit)genericSplit;
        this.start = split.getStart() << 16;
        this.end = this.start + split.getLength() << 16;
        Path file = split.getPath();
        FileSystem fs = file.getFileSystem(conf);
        this.bin = new BlockCompressedInputStream(new WrapSeekable<FSDataInputStream>(fs.open(file), fs.getFileStatus(file).getLen(), file));
        this.in = new LineReader((InputStream)this.bin, conf);
        if (this.start != 0L) {
            this.bin.seek(this.start);
            this.in.readLine(new Text());
            this.start = this.bin.getFilePointer();
        }
        this.pos = this.start;
    }

    public boolean nextKeyValue() throws IOException {
        while (this.pos <= this.end) {
            int newSize = this.in.readLine(this.value, this.maxLineLength);
            if (newSize == 0) {
                return false;
            }
            this.pos = this.bin.getFilePointer();
            if (newSize >= this.maxLineLength) continue;
            return true;
        }
        return false;
    }

    public NullWritable getCurrentKey() {
        return NullWritable.get();
    }

    public Text getCurrentValue() {
        return this.value;
    }

    public float getProgress() {
        if (this.start == this.end) {
            return 0.0f;
        }
        return Math.min(1.0f, (float)(this.pos - this.start) / (float)(this.end - this.start));
    }

    public void close() throws IOException {
        this.in.close();
    }
}

