/*
 * Decompiled with CFR 0.152.
 */
package org.seqdoop.hadoop_bam;

import htsjdk.samtools.util.BlockCompressedInputStream;
import java.io.IOException;
import java.io.InputStream;

class BGZFLimitingStream
extends InputStream {
    private final BlockCompressedInputStream bgzf;
    private final long virtEnd;
    private byte[] readBuf = new byte[1];

    public BGZFLimitingStream(BlockCompressedInputStream stream, long virtualEnd) {
        this.bgzf = stream;
        this.virtEnd = virtualEnd;
    }

    @Override
    public void close() throws IOException {
        this.bgzf.close();
    }

    @Override
    public int read() throws IOException {
        switch (this.read(this.readBuf)) {
            case 1: {
                return this.readBuf[0];
            }
            case -1: {
                return -1;
            }
        }
        assert (false);
        return -1;
    }

    @Override
    public int read(byte[] buf, int off, int len) throws IOException {
        int r;
        long virt;
        int totalRead = 0;
        int lastLen = (int)this.virtEnd & 0xFFFF;
        while ((virt = this.bgzf.getFilePointer()) >>> 16 != this.virtEnd >>> 16) {
            r = this.bgzf.read(buf, off, Math.min(len, lastLen));
            if (r == -1) {
                return totalRead == 0 ? -1 : totalRead;
            }
            totalRead += r;
            if ((len -= r) == 0) {
                return totalRead;
            }
            off += r;
        }
        len = Math.min(len, ((int)virt & 0xFFFF) - lastLen);
        while (len > 0) {
            r = this.bgzf.read(buf, off, len);
            if (r == -1) {
                return totalRead == 0 ? -1 : totalRead;
            }
            totalRead += r;
            len -= r;
            off += r;
        }
        return totalRead == 0 ? -1 : totalRead;
    }
}

