/*
 * Decompiled with CFR 0.152.
 */
package org.seqdoop.hadoop_bam;

import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMFormatException;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMRecordIterator;
import htsjdk.samtools.SamInputResource;
import htsjdk.samtools.SamReader;
import htsjdk.samtools.SamReaderFactory;
import htsjdk.samtools.ValidationStringency;
import java.io.IOException;
import java.io.InputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;
import org.seqdoop.hadoop_bam.BAMRecordReader;
import org.seqdoop.hadoop_bam.SAMRecordWritable;
import org.seqdoop.hadoop_bam.WorkaroundingStream;
import org.seqdoop.hadoop_bam.util.SAMHeaderReader;

public class SAMRecordReader
extends RecordReader<LongWritable, SAMRecordWritable> {
    private LongWritable key = new LongWritable();
    private SAMRecordWritable record = new SAMRecordWritable();
    private FSDataInputStream input;
    private SAMRecordIterator iterator;
    private long start;
    private long end;
    private boolean isInitialized = false;
    private WorkaroundingStream waInput;

    public void initialize(InputSplit spl, TaskAttemptContext ctx) throws IOException {
        boolean firstSplit;
        if (this.isInitialized) {
            this.close();
        }
        this.isInitialized = true;
        FileSplit split = (FileSplit)spl;
        this.start = split.getStart();
        this.end = this.start + split.getLength();
        Configuration conf = ctx.getConfiguration();
        ValidationStringency stringency = SAMHeaderReader.getValidationStringency(conf);
        Path file = split.getPath();
        FileSystem fs = file.getFileSystem(conf);
        this.input = fs.open(file);
        SAMFileHeader header = this.createSamReader((InputStream)this.input, stringency).getFileHeader();
        this.waInput = new WorkaroundingStream((InputStream)this.input, header);
        boolean bl = firstSplit = this.start == 0L;
        if (firstSplit) {
            int headerLength = this.waInput.getRemainingHeaderLength();
            this.input.seek((long)headerLength);
            this.start += (long)headerLength;
        } else {
            this.input.seek(--this.start);
        }
        this.waInput.setLength(this.end - this.start);
        this.iterator = this.createSamReader(this.waInput, stringency).iterator();
        if (!firstSplit) {
            try {
                if (this.iterator.hasNext()) {
                    this.iterator.next();
                }
            }
            catch (SAMFormatException e) {
                // empty catch block
            }
        }
    }

    private SamReader createSamReader(InputStream in, ValidationStringency stringency) {
        SamReaderFactory readerFactory = SamReaderFactory.makeDefault().setOption(SamReaderFactory.Option.EAGERLY_DECODE, false).setUseAsyncIo(false);
        if (stringency != null) {
            readerFactory.validationStringency(stringency);
        }
        return readerFactory.open(SamInputResource.of((InputStream)in));
    }

    public void close() throws IOException {
        this.iterator.close();
    }

    public float getProgress() throws IOException {
        long pos = this.input.getPos();
        if (pos >= this.end) {
            return 1.0f;
        }
        return (float)(pos - this.start) / (float)(this.end - this.start);
    }

    public LongWritable getCurrentKey() {
        return this.key;
    }

    public SAMRecordWritable getCurrentValue() {
        return this.record;
    }

    public boolean nextKeyValue() {
        if (!this.iterator.hasNext()) {
            return false;
        }
        SAMRecord r = (SAMRecord)this.iterator.next();
        this.key.set(BAMRecordReader.getKey(r));
        this.record.set(r);
        return true;
    }
}

