/*
 * Decompiled with CFR 0.152.
 */
package org.seqdoop.hadoop_bam.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.hadoop.fs.Seekable;
import org.apache.hadoop.io.compress.CompressionOutputStream;
import org.apache.hadoop.io.compress.Compressor;
import org.apache.hadoop.io.compress.Decompressor;
import org.apache.hadoop.io.compress.GzipCodec;
import org.apache.hadoop.io.compress.SplitCompressionInputStream;
import org.apache.hadoop.io.compress.SplittableCompressionCodec;
import org.seqdoop.hadoop_bam.util.BGZFCompressionOutputStream;
import org.seqdoop.hadoop_bam.util.BGZFSplitCompressionInputStream;
import org.seqdoop.hadoop_bam.util.BGZFSplitGuesser;

public class BGZFCodec
extends GzipCodec
implements SplittableCompressionCodec {
    public static final String DEFAULT_EXTENSION = ".bgz";

    public CompressionOutputStream createOutputStream(OutputStream out) throws IOException {
        return new BGZFCompressionOutputStream(out);
    }

    public CompressionOutputStream createOutputStream(OutputStream out, Compressor compressor) throws IOException {
        return this.createOutputStream(out);
    }

    public Class<? extends Compressor> getCompressorType() {
        return null;
    }

    public Compressor createCompressor() {
        return null;
    }

    public SplitCompressionInputStream createInputStream(InputStream seekableIn, Decompressor decompressor, long start, long end, SplittableCompressionCodec.READ_MODE readMode) throws IOException {
        BGZFSplitGuesser splitGuesser = new BGZFSplitGuesser(seekableIn);
        long adjustedStart = splitGuesser.guessNextBGZFBlockStart(start, end);
        ((Seekable)seekableIn).seek(adjustedStart);
        return new BGZFSplitCompressionInputStream(seekableIn, adjustedStart, end);
    }

    public String getDefaultExtension() {
        return DEFAULT_EXTENSION;
    }
}

