/*
 * Decompiled with CFR 0.152.
 */
package org.sheinbergon.aac.jna;

import com.sun.jna.Memory;
import com.sun.jna.Pointer;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.PointerByReference;
import java.util.Optional;
import org.sheinbergon.aac.jna.FdkAACLib;
import org.sheinbergon.aac.jna.structure.AACEncBufDesc;
import org.sheinbergon.aac.jna.structure.AACEncInArgs;
import org.sheinbergon.aac.jna.structure.AACEncInfo;
import org.sheinbergon.aac.jna.structure.AACEncOutArgs;
import org.sheinbergon.aac.jna.structure.AACEncoder;
import org.sheinbergon.aac.jna.util.AACEncError;
import org.sheinbergon.aac.jna.util.AACEncParam;
import org.sheinbergon.aac.jna.util.FdkAACLibException;

public class FdkAACLibFacade {
    private static final int IN_BUFFER_COUNT = 1;
    private static final int IN_BUFFER_IDENTIFIER = 0;
    private static final int IN_BUFFER_ELEMENT_SIZE = 2;
    private static final int IN_SAMPLES_DIVISOR = 2;
    private static final int OUT_BUFFER_COUNT = 1;
    private static final int OUT_BUFFER_IDENTIFIER = 3;
    private static final int OUT_BUFFER_ELEMENT_SIZE = 1;

    public static AACEncoder openEncoder(int modules, int maxChannels) {
        PointerByReference pointerRef = new PointerByReference();
        AACEncError result = AACEncError.valueOf(FdkAACLib.aacEncOpen(pointerRef, modules, maxChannels));
        FdkAACLibFacade.verifyResult(result, FdkAACLib.Methods.OPEN);
        return AACEncoder.of(pointerRef);
    }

    public static void closeEncoder(AACEncoder encoder) {
        Pointer pointer = encoder.getPointer();
        AACEncError result = AACEncError.valueOf(FdkAACLib.aacEncClose(new PointerByReference(pointer)));
        FdkAACLibFacade.verifyResult(result, FdkAACLib.Methods.CLOSE);
    }

    public static void initEncoder(AACEncoder encoder) {
        AACEncError result = AACEncError.valueOf(FdkAACLib.aacEncEncode(encoder, null, null, null, null));
        FdkAACLibFacade.verifyResult(result, FdkAACLib.Methods.ENCODE);
    }

    public static Optional<byte[]> encode(AACEncoder encoder, AACEncBufDesc inBufferDescriptor, AACEncBufDesc outBufferDescriptor, int size) {
        AACEncInArgs inArgs = new AACEncInArgs();
        AACEncOutArgs outArgs = new AACEncOutArgs();
        inArgs.numInSamples = size == -1 ? size : size / 2;
        return Optional.ofNullable(AACEncError.valueOf(FdkAACLib.aacEncEncode(encoder, inBufferDescriptor, outBufferDescriptor, inArgs, outArgs))).filter(result -> result != AACEncError.AACENC_ENCODE_EOF).map(result -> {
            FdkAACLibFacade.verifyResult(result, FdkAACLib.Methods.GET_LIB_INFO);
            return outBufferDescriptor.bufs.getValue().getByteArray(0L, outArgs.numOutBytes);
        });
    }

    public static AACEncInfo getEncoderInfo(AACEncoder encoder) {
        AACEncInfo info = new AACEncInfo();
        AACEncError result = AACEncError.valueOf(FdkAACLib.aacEncInfo(encoder, info));
        FdkAACLibFacade.verifyResult(result, FdkAACLib.Methods.INFO);
        info.read();
        return info;
    }

    public static void setEncoderParam(AACEncoder encoder, AACEncParam param, int value) {
        AACEncError result = AACEncError.valueOf(FdkAACLib.aacEncoder_SetParam(encoder, param.getValue(), value));
        FdkAACLibFacade.verifyResult(result, FdkAACLib.Methods.SET_PARAM);
    }

    private static void verifyResult(AACEncError result, FdkAACLib.Methods method) {
        Optional.of(result).filter(error -> !error.equals((Object)AACEncError.AACENC_OK)).ifPresent(error -> {
            throw new FdkAACLibException((AACEncError)((Object)error), method.method);
        });
    }

    public static AACEncBufDesc outBufferDescriptor(Memory buffer) {
        AACEncBufDesc descriptor = new AACEncBufDesc();
        descriptor.numBufs = 1;
        descriptor.bufs = new PointerByReference((Pointer)buffer);
        descriptor.bufSizes = new IntByReference((int)buffer.size());
        descriptor.bufferIdentifiers = new IntByReference(3);
        descriptor.bufElSizes = new IntByReference(1);
        descriptor.write();
        return descriptor;
    }

    public static AACEncBufDesc inBufferDescriptor(Memory buffer) {
        AACEncBufDesc descriptor = new AACEncBufDesc();
        descriptor.numBufs = 1;
        descriptor.bufs = new PointerByReference((Pointer)buffer);
        descriptor.bufSizes = new IntByReference((int)buffer.size());
        descriptor.bufferIdentifiers = new IntByReference(0);
        descriptor.bufElSizes = new IntByReference(2);
        descriptor.write();
        return descriptor;
    }
}

