/*
 * Decompiled with CFR 0.152.
 */
package org.shredzone.acme4j;

import edu.umd.cs.findbugs.annotations.Nullable;
import java.io.IOException;
import java.io.Writer;
import java.net.URL;
import java.security.KeyPair;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.shredzone.acme4j.AcmeResource;
import org.shredzone.acme4j.Login;
import org.shredzone.acme4j.RevocationReason;
import org.shredzone.acme4j.Session;
import org.shredzone.acme4j.connector.Connection;
import org.shredzone.acme4j.connector.Resource;
import org.shredzone.acme4j.exception.AcmeException;
import org.shredzone.acme4j.exception.AcmeLazyLoadingException;
import org.shredzone.acme4j.exception.AcmeProtocolException;
import org.shredzone.acme4j.toolbox.AcmeUtils;
import org.shredzone.acme4j.toolbox.JSONBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Certificate
extends AcmeResource {
    private static final long serialVersionUID = 7381527770159084201L;
    private static final Logger LOG = LoggerFactory.getLogger(Certificate.class);
    @Nullable
    private ArrayList<X509Certificate> certChain;
    @Nullable
    private ArrayList<URL> alternates;

    protected Certificate(Login login, URL certUrl) {
        super(login, certUrl);
    }

    public void download() throws AcmeException {
        if (this.certChain == null) {
            LOG.debug("download");
            try (Connection conn = this.getSession().connect();){
                conn.sendCertificateRequest(this.getLocation(), this.getLogin());
                this.alternates = new ArrayList<URL>(conn.getLinks("alternate"));
                this.certChain = new ArrayList<X509Certificate>(conn.readCertificates());
            }
        }
    }

    public X509Certificate getCertificate() {
        this.lazyDownload();
        return this.certChain.get(0);
    }

    public List<X509Certificate> getCertificateChain() {
        this.lazyDownload();
        return Collections.unmodifiableList(this.certChain);
    }

    public List<URL> getAlternates() {
        this.lazyDownload();
        if (this.alternates != null) {
            return Collections.unmodifiableList(this.alternates);
        }
        return Collections.emptyList();
    }

    public void writeCertificate(Writer out) throws IOException {
        try {
            for (X509Certificate cert : this.getCertificateChain()) {
                AcmeUtils.writeToPem(cert.getEncoded(), AcmeUtils.PemLabel.CERTIFICATE, out);
            }
        }
        catch (CertificateEncodingException ex) {
            throw new IOException("Encoding error", ex);
        }
    }

    public void revoke() throws AcmeException {
        this.revoke(null);
    }

    public void revoke(@Nullable RevocationReason reason) throws AcmeException {
        Certificate.revoke(this.getLogin(), this.getCertificate(), reason);
    }

    public static void revoke(Login login, X509Certificate cert, @Nullable RevocationReason reason) throws AcmeException {
        LOG.debug("revoke");
        Session session = login.getSession();
        URL resUrl = session.resourceUrl(Resource.REVOKE_CERT);
        try (Connection conn = session.connect();){
            JSONBuilder claims = new JSONBuilder();
            claims.putBase64("certificate", cert.getEncoded());
            if (reason != null) {
                claims.put("reason", reason.getReasonCode());
            }
            conn.sendSignedRequest(resUrl, claims, login);
        }
        catch (CertificateEncodingException ex) {
            throw new AcmeProtocolException("Invalid certificate", ex);
        }
    }

    public static void revoke(Session session, KeyPair domainKeyPair, X509Certificate cert, @Nullable RevocationReason reason) throws AcmeException {
        LOG.debug("revoke using the domain key pair");
        URL resUrl = session.resourceUrl(Resource.REVOKE_CERT);
        try (Connection conn = session.connect();){
            JSONBuilder claims = new JSONBuilder();
            claims.putBase64("certificate", cert.getEncoded());
            if (reason != null) {
                claims.put("reason", reason.getReasonCode());
            }
            conn.sendSignedRequest(resUrl, claims, session, domainKeyPair);
        }
        catch (CertificateEncodingException ex) {
            throw new AcmeProtocolException("Invalid certificate", ex);
        }
    }

    private void lazyDownload() {
        try {
            this.download();
        }
        catch (AcmeException ex) {
            throw new AcmeLazyLoadingException(this, ex);
        }
    }
}

