/*
 * Decompiled with CFR 0.152.
 */
package org.shredzone.acme4j.connector;

import edu.umd.cs.findbugs.annotations.Nullable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.KeyPair;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.shredzone.acme4j.Login;
import org.shredzone.acme4j.Problem;
import org.shredzone.acme4j.Session;
import org.shredzone.acme4j.connector.Connection;
import org.shredzone.acme4j.connector.HttpConnector;
import org.shredzone.acme4j.connector.Resource;
import org.shredzone.acme4j.connector.TrimmingInputStream;
import org.shredzone.acme4j.exception.AcmeException;
import org.shredzone.acme4j.exception.AcmeNetworkException;
import org.shredzone.acme4j.exception.AcmeProtocolException;
import org.shredzone.acme4j.exception.AcmeRateLimitedException;
import org.shredzone.acme4j.exception.AcmeRetryAfterException;
import org.shredzone.acme4j.exception.AcmeServerException;
import org.shredzone.acme4j.exception.AcmeUnauthorizedException;
import org.shredzone.acme4j.exception.AcmeUserActionRequiredException;
import org.shredzone.acme4j.toolbox.AcmeUtils;
import org.shredzone.acme4j.toolbox.JSON;
import org.shredzone.acme4j.toolbox.JSONBuilder;
import org.shredzone.acme4j.toolbox.JoseUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultConnection
implements Connection {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultConnection.class);
    private static final String ACCEPT_HEADER = "Accept";
    private static final String ACCEPT_CHARSET_HEADER = "Accept-Charset";
    private static final String ACCEPT_LANGUAGE_HEADER = "Accept-Language";
    private static final String CACHE_CONTROL_HEADER = "Cache-Control";
    private static final String CONTENT_TYPE_HEADER = "Content-Type";
    private static final String DATE_HEADER = "Date";
    private static final String EXPIRES_HEADER = "Expires";
    private static final String IF_MODIFIED_SINCE_HEADER = "If-Modified-Since";
    private static final String LAST_MODIFIED_HEADER = "Last-Modified";
    private static final String LINK_HEADER = "Link";
    private static final String LOCATION_HEADER = "Location";
    private static final String REPLAY_NONCE_HEADER = "Replay-Nonce";
    private static final String RETRY_AFTER_HEADER = "Retry-After";
    private static final String DEFAULT_CHARSET = "utf-8";
    private static final String MIME_JSON = "application/json";
    private static final String MIME_JSON_PROBLEM = "application/problem+json";
    private static final String MIME_CERTIFICATE_CHAIN = "application/pem-certificate-chain";
    private static final URI BAD_NONCE_ERROR = URI.create("urn:ietf:params:acme:error:badNonce");
    private static final int MAX_ATTEMPTS = 10;
    private static final Pattern NO_CACHE_PATTERN = Pattern.compile("(?:^|.*?,)\\s*no-(?:cache|store)\\s*(?:,.*|$)", 2);
    private static final Pattern MAX_AGE_PATTERN = Pattern.compile("(?:^|.*?,)\\s*max-age=(\\d+)\\s*(?:,.*|$)", 2);
    protected final HttpConnector httpConnector;
    @Nullable
    protected HttpURLConnection conn;

    public DefaultConnection(HttpConnector httpConnector) {
        this.httpConnector = Objects.requireNonNull(httpConnector, "httpConnector");
    }

    @Override
    public void resetNonce(Session session) throws AcmeException {
        this.assertConnectionIsClosed();
        try {
            String nonce;
            session.setNonce(null);
            URL newNonceUrl = session.resourceUrl(Resource.NEW_NONCE);
            LOG.debug("HEAD {}", (Object)newNonceUrl);
            this.conn = this.httpConnector.openConnection(newNonceUrl, session.networkSettings());
            this.conn.setRequestMethod("HEAD");
            this.conn.setRequestProperty(ACCEPT_LANGUAGE_HEADER, session.getLocale().toLanguageTag());
            this.conn.connect();
            this.logHeaders();
            int rc = this.conn.getResponseCode();
            if (rc != 200 && rc != 204) {
                this.throwAcmeException();
            }
            if ((nonce = this.getNonce()) == null) {
                throw new AcmeProtocolException("Server did not provide a nonce");
            }
            session.setNonce(nonce);
        }
        catch (IOException ex) {
            throw new AcmeNetworkException(ex);
        }
        finally {
            this.conn = null;
        }
    }

    @Override
    public int sendRequest(URL url, Session session, @Nullable ZonedDateTime ifModifiedSince) throws AcmeException {
        return this.sendRequest(url, session, MIME_JSON, ifModifiedSince);
    }

    @Override
    public int sendCertificateRequest(URL url, Login login) throws AcmeException {
        return this.sendSignedRequest(url, null, login.getSession(), login.getKeyPair(), login.getAccountLocation(), MIME_CERTIFICATE_CHAIN);
    }

    @Override
    public int sendSignedPostAsGetRequest(URL url, Login login) throws AcmeException {
        return this.sendSignedRequest(url, null, login.getSession(), login.getKeyPair(), login.getAccountLocation(), MIME_JSON);
    }

    @Override
    public int sendSignedRequest(URL url, JSONBuilder claims, Login login) throws AcmeException {
        return this.sendSignedRequest(url, claims, login.getSession(), login.getKeyPair(), login.getAccountLocation(), MIME_JSON);
    }

    @Override
    public int sendSignedRequest(URL url, JSONBuilder claims, Session session, KeyPair keypair) throws AcmeException {
        return this.sendSignedRequest(url, claims, session, keypair, null, MIME_JSON);
    }

    @Override
    public JSON readJsonResponse() throws AcmeException {
        this.assertConnectionIsOpen();
        if (this.conn.getContentLength() == 0) {
            throw new AcmeProtocolException("Empty response");
        }
        String contentType = AcmeUtils.getContentType(this.conn.getHeaderField(CONTENT_TYPE_HEADER));
        if (!MIME_JSON.equals(contentType) && !MIME_JSON_PROBLEM.equals(contentType)) {
            throw new AcmeProtocolException("Unexpected content type: " + contentType);
        }
        try {
            InputStream in;
            InputStream inputStream = in = this.conn.getResponseCode() < 400 ? this.conn.getInputStream() : this.conn.getErrorStream();
            if (in == null) {
                throw new AcmeProtocolException("JSON response is empty");
            }
            JSON result = JSON.parse(in);
            LOG.debug("Result JSON: {}", (Object)result);
            return result;
        }
        catch (IOException ex) {
            throw new AcmeNetworkException(ex);
        }
    }

    @Override
    public List<X509Certificate> readCertificates() throws AcmeException {
        List<X509Certificate> list;
        this.assertConnectionIsOpen();
        String contentType = AcmeUtils.getContentType(this.conn.getHeaderField(CONTENT_TYPE_HEADER));
        if (!MIME_CERTIFICATE_CHAIN.equals(contentType)) {
            throw new AcmeProtocolException("Unexpected content type: " + contentType);
        }
        TrimmingInputStream in = new TrimmingInputStream(this.conn.getInputStream());
        try {
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            list = cf.generateCertificates(in).stream().map(c -> (X509Certificate)c).collect(Collectors.toList());
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)in).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException ex) {
                throw new AcmeNetworkException(ex);
            }
            catch (CertificateException ex) {
                throw new AcmeProtocolException("Failed to read certificate", ex);
            }
        }
        ((InputStream)in).close();
        return list;
    }

    @Override
    public void handleRetryAfter(String message) throws AcmeException {
        this.assertConnectionIsOpen();
        Optional<Instant> retryAfter = this.getRetryAfterHeader();
        if (retryAfter.isPresent()) {
            throw new AcmeRetryAfterException(message, retryAfter.get());
        }
    }

    @Override
    @Nullable
    public String getNonce() {
        this.assertConnectionIsOpen();
        String nonceHeader = this.conn.getHeaderField(REPLAY_NONCE_HEADER);
        if (nonceHeader == null || nonceHeader.trim().isEmpty()) {
            return null;
        }
        if (!AcmeUtils.isValidBase64Url(nonceHeader)) {
            throw new AcmeProtocolException("Invalid replay nonce: " + nonceHeader);
        }
        LOG.debug("Replay Nonce: {}", (Object)nonceHeader);
        return nonceHeader;
    }

    @Override
    @Nullable
    public URL getLocation() {
        this.assertConnectionIsOpen();
        String location = this.conn.getHeaderField(LOCATION_HEADER);
        if (location == null) {
            return null;
        }
        LOG.debug("Location: {}", (Object)location);
        return this.resolveRelative(location);
    }

    @Override
    public Optional<ZonedDateTime> getLastModified() {
        this.assertConnectionIsOpen();
        String header = this.conn.getHeaderField(LAST_MODIFIED_HEADER);
        if (header != null) {
            try {
                return Optional.of(ZonedDateTime.parse(header, DateTimeFormatter.RFC_1123_DATE_TIME));
            }
            catch (DateTimeParseException ex) {
                LOG.debug("Ignored invalid Last-Modified date: {}", (Object)header, (Object)ex);
            }
        }
        return Optional.empty();
    }

    @Override
    public Optional<ZonedDateTime> getExpiration() {
        String expiresHeader;
        this.assertConnectionIsOpen();
        String cacheHeader = this.conn.getHeaderField(CACHE_CONTROL_HEADER);
        if (cacheHeader != null) {
            if (NO_CACHE_PATTERN.matcher(cacheHeader).matches()) {
                return Optional.empty();
            }
            Matcher m = MAX_AGE_PATTERN.matcher(cacheHeader);
            if (m.matches()) {
                int maxAge = Integer.parseInt(m.group(1));
                if (maxAge == 0) {
                    return Optional.empty();
                }
                return Optional.of(ZonedDateTime.now(ZoneId.of("UTC")).plusSeconds(maxAge));
            }
        }
        if ((expiresHeader = this.conn.getHeaderField(EXPIRES_HEADER)) != null) {
            try {
                return Optional.of(ZonedDateTime.parse(expiresHeader, DateTimeFormatter.RFC_1123_DATE_TIME));
            }
            catch (DateTimeParseException ex) {
                LOG.debug("Ignored invalid Expires date: {}", (Object)expiresHeader, (Object)ex);
            }
        }
        return Optional.empty();
    }

    @Override
    public Collection<URL> getLinks(String relation) {
        return this.collectLinks(relation).stream().map(this::resolveRelative).collect(Collectors.toList());
    }

    @Override
    public void close() {
        this.conn = null;
    }

    protected int sendRequest(URL url, Session session, String accept, @Nullable ZonedDateTime ifModifiedSince) throws AcmeException {
        Objects.requireNonNull(url, "url");
        Objects.requireNonNull(session, "session");
        Objects.requireNonNull(accept, "accept");
        this.assertConnectionIsClosed();
        LOG.debug("GET {}", (Object)url);
        try {
            int rc;
            this.conn = this.httpConnector.openConnection(url, session.networkSettings());
            this.conn.setRequestMethod("GET");
            this.conn.setRequestProperty(ACCEPT_HEADER, accept);
            this.conn.setRequestProperty(ACCEPT_CHARSET_HEADER, DEFAULT_CHARSET);
            this.conn.setRequestProperty(ACCEPT_LANGUAGE_HEADER, session.getLocale().toLanguageTag());
            if (ifModifiedSince != null) {
                this.conn.setRequestProperty(IF_MODIFIED_SINCE_HEADER, ifModifiedSince.format(DateTimeFormatter.RFC_1123_DATE_TIME));
            }
            this.conn.setDoOutput(false);
            this.conn.connect();
            this.logHeaders();
            String nonce = this.getNonce();
            if (nonce != null) {
                session.setNonce(nonce);
            }
            if ((rc = this.conn.getResponseCode()) != 200 && rc != 201 && (rc != 304 || ifModifiedSince == null)) {
                this.throwAcmeException();
            }
            return rc;
        }
        catch (IOException ex) {
            throw new AcmeNetworkException(ex);
        }
    }

    protected int sendSignedRequest(URL url, @Nullable JSONBuilder claims, Session session, KeyPair keypair, @Nullable URL accountLocation, String accept) throws AcmeException {
        Objects.requireNonNull(url, "url");
        Objects.requireNonNull(session, "session");
        Objects.requireNonNull(keypair, "keypair");
        Objects.requireNonNull(accept, "accept");
        this.assertConnectionIsClosed();
        int attempt = 1;
        while (true) {
            try {
                return this.performRequest(url, claims, session, keypair, accountLocation, accept);
            }
            catch (AcmeServerException ex) {
                if (!BAD_NONCE_ERROR.equals(ex.getType())) {
                    throw ex;
                }
                if (attempt == 10) {
                    throw ex;
                }
                LOG.info("Bad Replay Nonce, trying again (attempt {}/{})", (Object)attempt, (Object)10);
                ++attempt;
                continue;
            }
            break;
        }
    }

    private int performRequest(URL url, @Nullable JSONBuilder claims, Session session, KeyPair keypair, @Nullable URL accountLocation, String accept) throws AcmeException {
        try {
            if (session.getNonce() == null) {
                this.resetNonce(session);
            }
            this.conn = this.httpConnector.openConnection(url, session.networkSettings());
            this.conn.setRequestMethod("POST");
            this.conn.setRequestProperty(ACCEPT_HEADER, accept);
            this.conn.setRequestProperty(ACCEPT_CHARSET_HEADER, DEFAULT_CHARSET);
            this.conn.setRequestProperty(ACCEPT_LANGUAGE_HEADER, session.getLocale().toLanguageTag());
            this.conn.setRequestProperty(CONTENT_TYPE_HEADER, "application/jose+json");
            this.conn.setDoOutput(true);
            JSONBuilder jose = JoseUtils.createJoseRequest(url, keypair, claims, session.getNonce(), accountLocation != null ? accountLocation.toString() : null);
            byte[] outputData = jose.toString().getBytes(StandardCharsets.UTF_8);
            this.conn.setFixedLengthStreamingMode(outputData.length);
            this.conn.connect();
            try (OutputStream out = this.conn.getOutputStream();){
                out.write(outputData);
            }
            this.logHeaders();
            session.setNonce(this.getNonce());
            int rc = this.conn.getResponseCode();
            if (rc != 200 && rc != 201) {
                this.throwAcmeException();
            }
            return rc;
        }
        catch (IOException ex) {
            throw new AcmeNetworkException(ex);
        }
    }

    private Optional<Instant> getRetryAfterHeader() {
        String header = this.conn.getHeaderField(RETRY_AFTER_HEADER);
        if (header != null) {
            try {
                if (header.matches("^\\d+$")) {
                    int delta = Integer.parseInt(header);
                    long date = this.conn.getHeaderFieldDate(DATE_HEADER, System.currentTimeMillis());
                    return Optional.of(Instant.ofEpochMilli(date).plusSeconds(delta));
                }
                long date = this.conn.getHeaderFieldDate(RETRY_AFTER_HEADER, 0L);
                if (date != 0L) {
                    return Optional.of(Instant.ofEpochMilli(date));
                }
            }
            catch (Exception ex) {
                throw new AcmeProtocolException("Bad retry-after header value: " + header, ex);
            }
        }
        return Optional.empty();
    }

    private void throwAcmeException() throws AcmeException {
        try {
            String contentType = AcmeUtils.getContentType(this.conn.getHeaderField(CONTENT_TYPE_HEADER));
            if (!MIME_JSON_PROBLEM.equals(contentType)) {
                throw new AcmeException("HTTP " + this.conn.getResponseCode() + ": " + this.conn.getResponseMessage());
            }
            Problem problem = new Problem(this.readJsonResponse(), this.conn.getURL());
            String error = AcmeUtils.stripErrorPrefix(problem.getType().toString());
            if ("unauthorized".equals(error)) {
                throw new AcmeUnauthorizedException(problem);
            }
            if ("userActionRequired".equals(error)) {
                URI tos = this.collectLinks("terms-of-service").stream().findFirst().map(this::resolveUri).orElse(null);
                throw new AcmeUserActionRequiredException(problem, tos);
            }
            if ("rateLimited".equals(error)) {
                Optional<Instant> retryAfter = this.getRetryAfterHeader();
                Collection<URL> rateLimits = this.getLinks("help");
                throw new AcmeRateLimitedException(problem, retryAfter.orElse(null), rateLimits);
            }
            throw new AcmeServerException(problem);
        }
        catch (IOException ex) {
            throw new AcmeNetworkException(ex);
        }
    }

    private void assertConnectionIsOpen() {
        if (this.conn == null) {
            throw new IllegalStateException("Not connected.");
        }
    }

    private void assertConnectionIsClosed() {
        if (this.conn != null) {
            throw new IllegalStateException("Previous connection is not closed.");
        }
    }

    private void logHeaders() {
        if (!LOG.isDebugEnabled()) {
            return;
        }
        this.conn.getHeaderFields().forEach((key, headers) -> headers.forEach(value -> LOG.debug("HEADER {}: {}", key, value)));
    }

    private Collection<String> collectLinks(String relation) {
        this.assertConnectionIsOpen();
        ArrayList<String> result = new ArrayList<String>();
        List<String> links = this.conn.getHeaderFields().get(LINK_HEADER);
        if (links != null) {
            Pattern p = Pattern.compile("<(.*?)>\\s*;\\s*rel=\"?" + Pattern.quote(relation) + "\"?");
            for (String link : links) {
                Matcher m = p.matcher(link);
                if (!m.matches()) continue;
                String location = m.group(1);
                LOG.debug("Link: {} -> {}", (Object)relation, (Object)location);
                result.add(location);
            }
        }
        return result;
    }

    @Nullable
    private URL resolveRelative(@Nullable String link) {
        if (link == null) {
            return null;
        }
        this.assertConnectionIsOpen();
        try {
            return new URL(this.conn.getURL(), link);
        }
        catch (MalformedURLException ex) {
            throw new AcmeProtocolException("Cannot resolve relative link: " + link, ex);
        }
    }

    @Nullable
    private URI resolveUri(@Nullable String uri) {
        if (uri == null) {
            return null;
        }
        try {
            return this.conn.getURL().toURI().resolve(uri);
        }
        catch (URISyntaxException ex) {
            throw new AcmeProtocolException("Invalid URI", ex);
        }
    }
}

