/*
 * Decompiled with CFR 0.152.
 */
package org.shredzone.acme4j;

import edu.umd.cs.findbugs.annotations.Nullable;
import java.io.Serializable;
import java.net.URL;
import java.util.Objects;
import org.shredzone.acme4j.Login;
import org.shredzone.acme4j.Session;

public abstract class AcmeResource
implements Serializable {
    private static final long serialVersionUID = -7930580802257379731L;
    @Nullable
    private transient Login login;
    private final URL location;

    protected AcmeResource(Login login, URL location) {
        this.location = Objects.requireNonNull(location, "location");
        this.rebind(login);
    }

    protected Login getLogin() {
        if (this.login == null) {
            throw new IllegalStateException("Use rebind() for binding this object to a login.");
        }
        return this.login;
    }

    protected Session getSession() {
        return this.getLogin().getSession();
    }

    public void rebind(Login login) {
        if (this.login != null) {
            throw new IllegalStateException("Resource is already bound to a login");
        }
        this.login = Objects.requireNonNull(login, "login");
    }

    public URL getLocation() {
        return this.location;
    }
}

