/*
 * Decompiled with CFR 0.152.
 */
package org.shredzone.acme4j.challenge;

import org.shredzone.acme4j.Identifier;
import org.shredzone.acme4j.Login;
import org.shredzone.acme4j.challenge.TokenChallenge;
import org.shredzone.acme4j.toolbox.AcmeUtils;
import org.shredzone.acme4j.toolbox.JSON;

public class Dns01Challenge
extends TokenChallenge {
    private static final long serialVersionUID = 6964687027713533075L;
    public static final String TYPE = "dns-01";
    public static final String RECORD_NAME_PREFIX = "_acme-challenge";

    public static String toRRName(Identifier identifier) {
        return Dns01Challenge.toRRName(identifier.getDomain());
    }

    public static String toRRName(String domain) {
        return "_acme-challenge." + domain + '.';
    }

    public Dns01Challenge(Login login, JSON data) {
        super(login, data);
    }

    public String getDigest() {
        return AcmeUtils.base64UrlEncode(AcmeUtils.sha256hash(this.getAuthorization()));
    }

    @Override
    protected boolean acceptable(String type) {
        return TYPE.equals(type);
    }
}

