/*
 * Decompiled with CFR 0.152.
 */
package org.shredzone.acme4j.provider;

import java.net.URI;
import java.time.ZonedDateTime;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.ServiceLoader;
import org.shredzone.acme4j.Login;
import org.shredzone.acme4j.Session;
import org.shredzone.acme4j.challenge.Challenge;
import org.shredzone.acme4j.challenge.Dns01Challenge;
import org.shredzone.acme4j.challenge.Http01Challenge;
import org.shredzone.acme4j.challenge.TlsAlpn01Challenge;
import org.shredzone.acme4j.challenge.TokenChallenge;
import org.shredzone.acme4j.connector.Connection;
import org.shredzone.acme4j.connector.DefaultConnection;
import org.shredzone.acme4j.connector.HttpConnector;
import org.shredzone.acme4j.exception.AcmeException;
import org.shredzone.acme4j.provider.AcmeProvider;
import org.shredzone.acme4j.provider.ChallengeProvider;
import org.shredzone.acme4j.provider.ChallengeType;
import org.shredzone.acme4j.toolbox.JSON;

public abstract class AbstractAcmeProvider
implements AcmeProvider {
    private static final Map<String, ChallengeProvider> CHALLENGES = AbstractAcmeProvider.challengeMap();

    @Override
    public Connection connect(URI serverUri) {
        return new DefaultConnection(this.createHttpConnector());
    }

    @Override
    public JSON directory(Session session, URI serverUri) throws AcmeException {
        ZonedDateTime expires = session.getDirectoryExpires();
        if (expires != null && expires.isAfter(ZonedDateTime.now())) {
            return null;
        }
        try (Connection conn = this.connect(serverUri);){
            ZonedDateTime lastModified = session.getDirectoryLastModified();
            int rc = conn.sendRequest(this.resolve(serverUri), session, lastModified);
            if (lastModified != null && rc == 304) {
                JSON jSON = null;
                return jSON;
            }
            session.setDirectoryLastModified(conn.getLastModified().orElse(null));
            session.setDirectoryExpires(conn.getExpiration().orElse(null));
            String nonce = conn.getNonce();
            if (nonce != null) {
                session.setNonce(nonce);
            }
            JSON jSON = conn.readJsonResponse();
            return jSON;
        }
    }

    private static Map<String, ChallengeProvider> challengeMap() {
        HashMap<String, ChallengeProvider> map = new HashMap<String, ChallengeProvider>();
        map.put("dns-01", Dns01Challenge::new);
        map.put("http-01", Http01Challenge::new);
        map.put("tls-alpn-01", TlsAlpn01Challenge::new);
        for (ChallengeProvider provider : ServiceLoader.load(ChallengeProvider.class)) {
            ChallengeType typeAnno = provider.getClass().getAnnotation(ChallengeType.class);
            if (typeAnno == null) {
                throw new IllegalStateException("ChallengeProvider " + provider.getClass().getName() + " has no @ChallengeType annotation");
            }
            String type = typeAnno.value();
            if (type == null || type.trim().isEmpty()) {
                throw new IllegalStateException("ChallengeProvider " + provider.getClass().getName() + ": type must not be null or empty");
            }
            if (map.containsKey(type)) {
                throw new IllegalStateException("ChallengeProvider " + provider.getClass().getName() + ": there is already a provider for challenge type " + type);
            }
            map.put(type, provider);
        }
        return Collections.unmodifiableMap(map);
    }

    @Override
    public Challenge createChallenge(Login login, JSON data) {
        Objects.requireNonNull(login, "login");
        Objects.requireNonNull(data, "data");
        String type = data.get("type").asString();
        ChallengeProvider constructor = CHALLENGES.get(type);
        if (constructor != null) {
            return constructor.create(login, data);
        }
        if (data.contains("token")) {
            return new TokenChallenge(login, data);
        }
        return new Challenge(login, data);
    }

    protected HttpConnector createHttpConnector() {
        return new HttpConnector();
    }
}

