/*
 * Decompiled with CFR 0.152.
 */
package org.shredzone.acme4j.toolbox;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.time.Duration;
import java.time.Instant;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.WillClose;
import javax.annotation.concurrent.Immutable;
import org.jose4j.json.JsonUtil;
import org.jose4j.lang.JoseException;
import org.shredzone.acme4j.Identifier;
import org.shredzone.acme4j.Problem;
import org.shredzone.acme4j.Status;
import org.shredzone.acme4j.exception.AcmeProtocolException;
import org.shredzone.acme4j.toolbox.AcmeUtils;

@ParametersAreNonnullByDefault
@Immutable
public final class JSON
implements Serializable {
    private static final long serialVersionUID = 3091273044605709204L;
    private static final JSON EMPTY_JSON = new JSON(new HashMap<String, Object>());
    private final String path;
    @SuppressFBWarnings(value={"JCIP_FIELD_ISNT_FINAL_IN_IMMUTABLE_CLASS"})
    private transient Map<String, Object> data;

    private JSON(Map<String, Object> data) {
        this("", data);
    }

    private JSON(String path, Map<String, Object> data) {
        this.path = path;
        this.data = data;
    }

    public static JSON parse(@WillClose InputStream in) throws IOException {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(in, "utf-8"));){
            String json = reader.lines().map(String::trim).collect(Collectors.joining());
            JSON jSON = JSON.parse(json);
            return jSON;
        }
    }

    public static JSON parse(String json) {
        try {
            return new JSON(JsonUtil.parseJson((String)json));
        }
        catch (JoseException ex) {
            throw new AcmeProtocolException("Bad JSON: " + json, ex);
        }
    }

    public static JSON empty() {
        return EMPTY_JSON;
    }

    public Set<String> keySet() {
        return Collections.unmodifiableSet(this.data.keySet());
    }

    public boolean contains(String key) {
        return this.data.containsKey(key);
    }

    public Value get(String key) {
        return new Value(this.path.isEmpty() ? key : this.path + '.' + key, this.data.get(key));
    }

    public String toString() {
        return JsonUtil.toJson(this.data);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeUTF(JsonUtil.toJson(this.data));
        out.defaultWriteObject();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        try {
            this.data = new HashMap<String, Object>(JsonUtil.parseJson((String)in.readUTF()));
            in.defaultReadObject();
        }
        catch (JoseException ex) {
            throw new AcmeProtocolException("Cannot deserialize", ex);
        }
    }

    @ParametersAreNonnullByDefault
    private static class ValueIterator
    implements Iterator<Value> {
        private final Array array;
        private int index = 0;

        public ValueIterator(Array array) {
            this.array = array;
        }

        @Override
        public boolean hasNext() {
            return this.index < this.array.size();
        }

        @Override
        public Value next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.array.get(this.index++);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    @ParametersAreNonnullByDefault
    @Immutable
    public static final class Value {
        private final String path;
        private final Object val;

        private Value(String path, @Nullable Object val) {
            this.path = path;
            this.val = val;
        }

        public boolean isPresent() {
            return this.val != null;
        }

        public Optional<Value> optional() {
            return this.val != null ? Optional.of(this) : Optional.empty();
        }

        public <T> Optional<T> map(Function<Value, T> mapper) {
            return this.optional().map(mapper);
        }

        public String asString() {
            this.required();
            return this.val.toString();
        }

        public JSON asObject() {
            this.required();
            try {
                return new JSON(this.path, (Map)this.val);
            }
            catch (ClassCastException ex) {
                throw new AcmeProtocolException(this.path + ": expected an object", ex);
            }
        }

        public Problem asProblem(URL baseUrl) {
            this.required();
            return new Problem(this.asObject(), baseUrl);
        }

        public Identifier asIdentifier() {
            this.required();
            return new Identifier(this.asObject());
        }

        public Array asArray() {
            if (this.val == null) {
                return new Array(this.path, Collections.emptyList());
            }
            try {
                return new Array(this.path, (List)this.val);
            }
            catch (ClassCastException ex) {
                throw new AcmeProtocolException(this.path + ": expected an array", ex);
            }
        }

        public int asInt() {
            this.required();
            try {
                return ((Number)this.val).intValue();
            }
            catch (ClassCastException ex) {
                throw new AcmeProtocolException(this.path + ": bad number " + this.val, ex);
            }
        }

        public boolean asBoolean() {
            this.required();
            try {
                return (Boolean)this.val;
            }
            catch (ClassCastException ex) {
                throw new AcmeProtocolException(this.path + ": bad boolean " + this.val, ex);
            }
        }

        public URI asURI() {
            this.required();
            try {
                return new URI(this.val.toString());
            }
            catch (URISyntaxException ex) {
                throw new AcmeProtocolException(this.path + ": bad URI " + this.val, ex);
            }
        }

        public URL asURL() {
            this.required();
            try {
                return new URL(this.val.toString());
            }
            catch (MalformedURLException ex) {
                throw new AcmeProtocolException(this.path + ": bad URL " + this.val, ex);
            }
        }

        public Instant asInstant() {
            this.required();
            try {
                return AcmeUtils.parseTimestamp(this.val.toString());
            }
            catch (IllegalArgumentException ex) {
                throw new AcmeProtocolException(this.path + ": bad date " + this.val, ex);
            }
        }

        public Duration asDuration() {
            this.required();
            try {
                return Duration.ofSeconds(((Number)this.val).longValue());
            }
            catch (ClassCastException ex) {
                throw new AcmeProtocolException(this.path + ": bad duration " + this.val, ex);
            }
        }

        public byte[] asBinary() {
            this.required();
            return AcmeUtils.base64UrlDecode(this.val.toString());
        }

        public Status asStatus() {
            this.required();
            return Status.parse(this.val.toString());
        }

        private void required() {
            if (!this.isPresent()) {
                throw new AcmeProtocolException(this.path + ": required, but not set");
            }
        }

        public boolean equals(Object obj) {
            if (obj == null || !(obj instanceof Value)) {
                return false;
            }
            return Objects.equals(this.val, ((Value)obj).val);
        }

        public int hashCode() {
            return this.val != null ? this.val.hashCode() : 0;
        }
    }

    @ParametersAreNonnullByDefault
    @Immutable
    public static final class Array
    implements Iterable<Value> {
        private final String path;
        private final List<Object> data;

        private Array(String path, List<Object> data) {
            this.path = path;
            this.data = data;
        }

        public int size() {
            return this.data.size();
        }

        public boolean isEmpty() {
            return this.data.isEmpty();
        }

        public Value get(int index) {
            return new Value(this.path + '[' + index + ']', this.data.get(index));
        }

        public Stream<Value> stream() {
            return StreamSupport.stream(this.spliterator(), false);
        }

        @Override
        public Iterator<Value> iterator() {
            return new ValueIterator(this);
        }
    }
}

