/*
 * Decompiled with CFR 0.152.
 */
package org.shredzone.acme4j;

import java.net.URI;
import java.net.URL;
import java.security.KeyPair;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.shredzone.acme4j.Account;
import org.shredzone.acme4j.Login;
import org.shredzone.acme4j.Session;
import org.shredzone.acme4j.connector.Connection;
import org.shredzone.acme4j.connector.Resource;
import org.shredzone.acme4j.exception.AcmeException;
import org.shredzone.acme4j.exception.AcmeProtocolException;
import org.shredzone.acme4j.toolbox.AcmeUtils;
import org.shredzone.acme4j.toolbox.JSONBuilder;
import org.shredzone.acme4j.toolbox.JoseUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ParametersAreNonnullByDefault
public class AccountBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(AccountBuilder.class);
    private List<URI> contacts = new ArrayList<URI>();
    private Boolean termsOfServiceAgreed;
    private Boolean onlyExisting;
    private String keyIdentifier;
    private KeyPair keyPair;
    private SecretKey macKey;

    public AccountBuilder addContact(URI contact) {
        AcmeUtils.validateContact(contact);
        this.contacts.add(contact);
        return this;
    }

    public AccountBuilder addContact(String contact) {
        this.addContact(URI.create(contact));
        return this;
    }

    public AccountBuilder addEmail(String email) {
        this.addContact("mailto:" + email);
        return this;
    }

    public AccountBuilder agreeToTermsOfService() {
        this.termsOfServiceAgreed = true;
        return this;
    }

    public AccountBuilder onlyExisting() {
        this.onlyExisting = true;
        return this;
    }

    public AccountBuilder useKeyPair(KeyPair keyPair) {
        this.keyPair = Objects.requireNonNull(keyPair, "keyPair");
        return this;
    }

    public AccountBuilder withKeyIdentifier(String kid, SecretKey macKey) {
        if (kid != null && kid.isEmpty()) {
            throw new IllegalArgumentException("kid must not be empty");
        }
        this.macKey = Objects.requireNonNull(macKey, "macKey");
        this.keyIdentifier = kid;
        return this;
    }

    public AccountBuilder withKeyIdentifier(String kid, String encodedMacKey) {
        byte[] encodedKey = AcmeUtils.base64UrlDecode(Objects.requireNonNull(encodedMacKey, "encodedMacKey"));
        return this.withKeyIdentifier(kid, new SecretKeySpec(encodedKey, "HMAC"));
    }

    public Account create(Session session) throws AcmeException {
        return this.createLogin(session).getAccount();
    }

    public Login createLogin(Session session) throws AcmeException {
        Objects.requireNonNull(session, "session");
        if (this.keyPair == null) {
            throw new IllegalStateException("Use AccountBuilder.useKeyPair() to set the account's key pair.");
        }
        LOG.debug("create");
        try (Connection conn = session.connect();){
            URL resourceUrl = session.resourceUrl(Resource.NEW_ACCOUNT);
            JSONBuilder claims = new JSONBuilder();
            if (!this.contacts.isEmpty()) {
                claims.put("contact", this.contacts);
            }
            if (this.termsOfServiceAgreed != null) {
                claims.put("termsOfServiceAgreed", this.termsOfServiceAgreed);
            }
            if (this.keyIdentifier != null) {
                claims.put("externalAccountBinding", JoseUtils.createExternalAccountBinding(this.keyIdentifier, this.keyPair.getPublic(), this.macKey, resourceUrl));
            }
            if (this.onlyExisting != null) {
                claims.put("onlyReturnExisting", this.onlyExisting);
            }
            conn.sendSignedRequest(resourceUrl, claims, session, this.keyPair);
            URL location = conn.getLocation();
            if (location == null) {
                throw new AcmeProtocolException("Server did not provide an account location");
            }
            Login login = new Login(location, this.keyPair, session);
            login.getAccount().setJSON(conn.readJsonResponse());
            Login login2 = login;
            return login2;
        }
    }
}

