/*
 * Decompiled with CFR 0.152.
 */
package org.shredzone.acme4j;

import java.net.URL;
import java.time.Instant;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.CheckForNull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.shredzone.acme4j.AcmeJsonResource;
import org.shredzone.acme4j.Identifier;
import org.shredzone.acme4j.Login;
import org.shredzone.acme4j.Status;
import org.shredzone.acme4j.challenge.Challenge;
import org.shredzone.acme4j.connector.Connection;
import org.shredzone.acme4j.exception.AcmeException;
import org.shredzone.acme4j.exception.AcmeProtocolException;
import org.shredzone.acme4j.toolbox.AcmeUtils;
import org.shredzone.acme4j.toolbox.JSON;
import org.shredzone.acme4j.toolbox.JSONBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ParametersAreNonnullByDefault
public class Authorization
extends AcmeJsonResource {
    private static final long serialVersionUID = -3116928998379417741L;
    private static final Logger LOG = LoggerFactory.getLogger(Authorization.class);

    protected Authorization(Login login, URL location) {
        super(login, location);
    }

    public Identifier getIdentifier() {
        return this.getJSON().get("identifier").asIdentifier();
    }

    public Status getStatus() {
        return this.getJSON().get("status").asStatus();
    }

    @CheckForNull
    public Instant getExpires() {
        return this.getJSON().get("expires").map(JSON.Value::asString).map(AcmeUtils::parseTimestamp).orElse(null);
    }

    public boolean isWildcard() {
        return this.getJSON().get("wildcard").map(JSON.Value::asBoolean).orElse(false);
    }

    public List<Challenge> getChallenges() {
        Login login = this.getLogin();
        return Collections.unmodifiableList(this.getJSON().get("challenges").asArray().stream().map(JSON.Value::asObject).map(login::createChallenge).collect(Collectors.toList()));
    }

    @CheckForNull
    public <T extends Challenge> T findChallenge(String type) {
        return (T)((Challenge)this.getChallenges().stream().filter(ch -> type.equals(ch.getType())).reduce((a, b) -> {
            throw new AcmeProtocolException("Found more than one challenge of type " + type);
        }).orElse(null));
    }

    @CheckForNull
    public <T extends Challenge> T findChallenge(Class<T> type) {
        return (T)((Challenge)this.getChallenges().stream().filter(type::isInstance).map(type::cast).reduce((a, b) -> {
            throw new AcmeProtocolException("Found more than one challenge of type " + type.getName());
        }).orElse(null));
    }

    public void deactivate() throws AcmeException {
        LOG.debug("deactivate");
        try (Connection conn = this.getSession().connect();){
            JSONBuilder claims = new JSONBuilder();
            claims.put("status", "deactivated");
            conn.sendSignedRequest(this.getLocation(), claims, this.getLogin());
            this.setJSON(conn.readJsonResponse());
        }
    }
}

