/*
 * Decompiled with CFR 0.152.
 */
package org.shredzone.acme4j;

import java.net.URL;
import java.time.Duration;
import java.time.Instant;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.CheckForNull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.shredzone.acme4j.AcmeJsonResource;
import org.shredzone.acme4j.Authorization;
import org.shredzone.acme4j.Certificate;
import org.shredzone.acme4j.Identifier;
import org.shredzone.acme4j.Login;
import org.shredzone.acme4j.Problem;
import org.shredzone.acme4j.Status;
import org.shredzone.acme4j.connector.Connection;
import org.shredzone.acme4j.exception.AcmeException;
import org.shredzone.acme4j.toolbox.JSON;
import org.shredzone.acme4j.toolbox.JSONBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ParametersAreNonnullByDefault
public class Order
extends AcmeJsonResource {
    private static final long serialVersionUID = 5435808648658292177L;
    private static final Logger LOG = LoggerFactory.getLogger(Order.class);

    protected Order(Login login, URL location) {
        super(login, location);
    }

    public Status getStatus() {
        return this.getJSON().get("status").asStatus();
    }

    @CheckForNull
    public Problem getError() {
        return this.getJSON().get("error").map(v -> v.asProblem(this.getLocation())).orElse(null);
    }

    @CheckForNull
    public Instant getExpires() {
        return this.getJSON().get("expires").map(JSON.Value::asInstant).orElse(null);
    }

    public List<Identifier> getIdentifiers() {
        return Collections.unmodifiableList(this.getJSON().get("identifiers").asArray().stream().map(JSON.Value::asIdentifier).collect(Collectors.toList()));
    }

    @CheckForNull
    public Instant getNotBefore() {
        return this.getJSON().get("notBefore").map(JSON.Value::asInstant).orElse(null);
    }

    @CheckForNull
    public Instant getNotAfter() {
        return this.getJSON().get("notAfter").map(JSON.Value::asInstant).orElse(null);
    }

    public List<Authorization> getAuthorizations() {
        Login login = this.getLogin();
        return Collections.unmodifiableList(this.getJSON().get("authorizations").asArray().stream().map(JSON.Value::asURL).map(login::bindAuthorization).collect(Collectors.toList()));
    }

    public URL getFinalizeLocation() {
        return this.getJSON().get("finalize").asURL();
    }

    @CheckForNull
    public Certificate getCertificate() {
        return this.getJSON().get("certificate").map(JSON.Value::asURL).map(this.getLogin()::bindCertificate).orElse(null);
    }

    @CheckForNull
    public Certificate getStarCertificate() {
        return this.getJSON().get("star-certificate").map(JSON.Value::asURL).map(this.getLogin()::bindCertificate).orElse(null);
    }

    public void execute(byte[] csr) throws AcmeException {
        LOG.debug("finalize");
        try (Connection conn = this.getSession().connect();){
            JSONBuilder claims = new JSONBuilder();
            claims.putBase64("csr", csr);
            conn.sendSignedRequest(this.getFinalizeLocation(), claims, this.getLogin());
        }
        this.invalidate();
    }

    public boolean isRecurrent() {
        return this.getJSON().get("recurrent").optional().map(JSON.Value::asBoolean).orElse(false);
    }

    @CheckForNull
    public Instant getRecurrentStart() {
        return this.getJSON().get("recurrent-start-date").optional().map(JSON.Value::asInstant).orElse(null);
    }

    @CheckForNull
    public Instant getRecurrentEnd() {
        return this.getJSON().get("recurrent-end-date").optional().map(JSON.Value::asInstant).orElse(null);
    }

    @CheckForNull
    public Duration getRecurrentCertificateValidity() {
        return this.getJSON().get("recurrent-certificate-validity").optional().map(JSON.Value::asDuration).orElse(null);
    }

    @CheckForNull
    public Duration getRecurrentCertificatePredate() {
        return this.getJSON().get("recurrent-certificate-predate").optional().map(JSON.Value::asDuration).orElse(null);
    }

    public boolean isRecurrentGetEnabled() {
        return this.getJSON().get("recurrent-certificate-get").optional().map(JSON.Value::asBoolean).orElse(false);
    }

    public void cancelRecurrent() throws AcmeException {
        if (!this.getSession().getMetadata().isStarEnabled()) {
            throw new AcmeException("CA does not support short-term automatic renewals");
        }
        LOG.debug("cancel");
        try (Connection conn = this.getSession().connect();){
            JSONBuilder claims = new JSONBuilder();
            claims.put("status", "canceled");
            conn.sendSignedRequest(this.getLocation(), claims, this.getLogin());
            this.setJSON(conn.readJsonResponse());
        }
    }
}

