/*
 * Decompiled with CFR 0.152.
 */
package org.shredzone.acme4j.connector;

import java.net.Proxy;
import java.time.Duration;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class NetworkSettings {
    private Proxy proxy = Proxy.NO_PROXY;
    private Duration timeout = Duration.ofSeconds(10L);

    public Proxy getProxy() {
        return this.proxy;
    }

    public void setProxy(@Nullable Proxy proxy) {
        this.proxy = proxy != null ? proxy : Proxy.NO_PROXY;
    }

    public Duration getTimeout() {
        return this.timeout;
    }

    public void setTimeout(Duration timeout) {
        if (timeout == null || timeout.isNegative() || timeout.isZero()) {
            throw new IllegalArgumentException("Timeout must be positive");
        }
        if (timeout.toMillis() > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Timeout is out of range");
        }
        this.timeout = timeout;
    }
}

