/*
 * Decompiled with CFR 0.152.
 */
package org.shredzone.acme4j.exception;

import edu.umd.cs.findbugs.annotations.Nullable;
import java.net.URL;
import java.time.Instant;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import org.shredzone.acme4j.Problem;
import org.shredzone.acme4j.exception.AcmeServerException;

public class AcmeRateLimitedException
extends AcmeServerException {
    private static final long serialVersionUID = 4150484059796413069L;
    @Nullable
    private final Instant retryAfter;
    private final Collection<URL> documents;

    public AcmeRateLimitedException(Problem problem, @Nullable Instant retryAfter, @Nullable Collection<URL> documents) {
        super(problem);
        this.retryAfter = retryAfter;
        this.documents = documents != null ? Collections.unmodifiableCollection(documents) : Collections.emptyList();
    }

    public Optional<Instant> getRetryAfter() {
        return Optional.ofNullable(this.retryAfter);
    }

    public Collection<URL> getDocuments() {
        return this.documents;
    }
}

