/*
 * Decompiled with CFR 0.152.
 */
package org.shredzone.acme4j;

import java.net.URI;
import java.net.URL;
import java.security.KeyPair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.shredzone.acme4j.AcmeJsonResource;
import org.shredzone.acme4j.Authorization;
import org.shredzone.acme4j.Identifier;
import org.shredzone.acme4j.Login;
import org.shredzone.acme4j.Order;
import org.shredzone.acme4j.OrderBuilder;
import org.shredzone.acme4j.Status;
import org.shredzone.acme4j.connector.Connection;
import org.shredzone.acme4j.connector.Resource;
import org.shredzone.acme4j.connector.ResourceIterator;
import org.shredzone.acme4j.exception.AcmeException;
import org.shredzone.acme4j.exception.AcmeNotSupportedException;
import org.shredzone.acme4j.toolbox.AcmeUtils;
import org.shredzone.acme4j.toolbox.JSON;
import org.shredzone.acme4j.toolbox.JSONBuilder;
import org.shredzone.acme4j.toolbox.JoseUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Account
extends AcmeJsonResource {
    private static final long serialVersionUID = 7042863483428051319L;
    private static final Logger LOG = LoggerFactory.getLogger(Account.class);
    private static final String KEY_TOS_AGREED = "termsOfServiceAgreed";
    private static final String KEY_ORDERS = "orders";
    private static final String KEY_CONTACT = "contact";
    private static final String KEY_STATUS = "status";
    private static final String KEY_EXTERNAL_ACCOUNT_BINDING = "externalAccountBinding";

    protected Account(Login login) {
        super(login, login.getAccountLocation());
    }

    public Optional<Boolean> getTermsOfServiceAgreed() {
        return this.getJSON().get(KEY_TOS_AGREED).map(JSON.Value::asBoolean);
    }

    public List<URI> getContacts() {
        return this.getJSON().get(KEY_CONTACT).asArray().stream().map(JSON.Value::asURI).collect(Collectors.toUnmodifiableList());
    }

    public Status getStatus() {
        return this.getJSON().get(KEY_STATUS).asStatus();
    }

    public boolean hasExternalAccountBinding() {
        return this.getJSON().contains(KEY_EXTERNAL_ACCOUNT_BINDING);
    }

    public Optional<String> getKeyIdentifier() {
        return this.getJSON().get(KEY_EXTERNAL_ACCOUNT_BINDING).optional().map(JSON.Value::asObject).map(j -> j.get("protected")).map(JSON.Value::asEncodedObject).map(j -> j.get("kid")).map(JSON.Value::asString);
    }

    public Iterator<Order> getOrders() {
        Optional<URL> ordersUrl = this.getJSON().get(KEY_ORDERS).optional().map(JSON.Value::asURL);
        if (ordersUrl.isEmpty()) {
            throw new AcmeNotSupportedException("getOrders()");
        }
        return new ResourceIterator<Order>(this.getLogin(), KEY_ORDERS, ordersUrl.get(), Login::bindOrder);
    }

    public OrderBuilder newOrder() {
        return this.getLogin().newOrder();
    }

    public Authorization preAuthorizeDomain(String domain) throws AcmeException {
        Objects.requireNonNull(domain, "domain");
        if (domain.isEmpty()) {
            throw new IllegalArgumentException("domain must not be empty");
        }
        return this.preAuthorize(Identifier.dns(domain));
    }

    public Authorization preAuthorize(Identifier identifier) throws AcmeException {
        Objects.requireNonNull(identifier, "identifier");
        URL newAuthzUrl = this.getSession().resourceUrl(Resource.NEW_AUTHZ);
        LOG.debug("preAuthorize {}", (Object)identifier);
        try (Connection conn = this.getSession().connect();){
            JSONBuilder claims = new JSONBuilder();
            claims.put("identifier", identifier.toMap());
            conn.sendSignedRequest(newAuthzUrl, claims, this.getLogin());
            Authorization auth = this.getLogin().bindAuthorization(conn.getLocation());
            auth.setJSON(conn.readJsonResponse());
            Authorization authorization = auth;
            return authorization;
        }
    }

    public void changeKey(KeyPair newKeyPair) throws AcmeException {
        Objects.requireNonNull(newKeyPair, "newKeyPair");
        if (Arrays.equals(this.getLogin().getKeyPair().getPrivate().getEncoded(), newKeyPair.getPrivate().getEncoded())) {
            throw new IllegalArgumentException("newKeyPair must actually be a new key pair");
        }
        LOG.debug("key-change");
        try (Connection conn = this.getSession().connect();){
            URL keyChangeUrl = this.getSession().resourceUrl(Resource.KEY_CHANGE);
            JSONBuilder payloadClaim = new JSONBuilder();
            payloadClaim.put("account", this.getLocation());
            payloadClaim.putKey("oldKey", this.getLogin().getKeyPair().getPublic());
            JSONBuilder jose = JoseUtils.createJoseRequest(keyChangeUrl, newKeyPair, payloadClaim, null, null);
            conn.sendSignedRequest(keyChangeUrl, jose, this.getLogin());
            this.getLogin().setKeyPair(newKeyPair);
        }
    }

    public void deactivate() throws AcmeException {
        LOG.debug("deactivate");
        try (Connection conn = this.getSession().connect();){
            JSONBuilder claims = new JSONBuilder();
            claims.put(KEY_STATUS, "deactivated");
            conn.sendSignedRequest(this.getLocation(), claims, this.getLogin());
            this.setJSON(conn.readJsonResponse());
        }
    }

    public EditableAccount modify() {
        return new EditableAccount();
    }

    public class EditableAccount {
        private final List<URI> editContacts = new ArrayList<URI>();

        private EditableAccount() {
            this.editContacts.addAll(Account.this.getContacts());
        }

        public List<URI> getContacts() {
            return this.editContacts;
        }

        public EditableAccount addContact(URI contact) {
            AcmeUtils.validateContact(contact);
            this.editContacts.add(contact);
            return this;
        }

        public EditableAccount addContact(String contact) {
            this.addContact(URI.create(contact));
            return this;
        }

        public EditableAccount addEmail(String email) {
            this.addContact("mailto:" + email);
            return this;
        }

        public void commit() throws AcmeException {
            LOG.debug("modify/commit");
            try (Connection conn = Account.this.getSession().connect();){
                JSONBuilder claims = new JSONBuilder();
                if (!this.editContacts.isEmpty()) {
                    claims.put(Account.KEY_CONTACT, this.editContacts);
                }
                conn.sendSignedRequest(Account.this.getLocation(), claims, Account.this.getLogin());
                Account.this.setJSON(conn.readJsonResponse());
            }
        }
    }
}

