/*
 * Decompiled with CFR 0.152.
 */
package org.shredzone.acme4j;

import edu.umd.cs.findbugs.annotations.Nullable;
import java.io.IOException;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.KeyPair;
import java.security.Principal;
import java.security.Security;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.ocsp.CertificateID;
import org.bouncycastle.operator.DigestCalculator;
import org.bouncycastle.operator.jcajce.JcaDigestCalculatorProviderBuilder;
import org.shredzone.acme4j.AcmeResource;
import org.shredzone.acme4j.Login;
import org.shredzone.acme4j.RenewalInfo;
import org.shredzone.acme4j.RevocationReason;
import org.shredzone.acme4j.Session;
import org.shredzone.acme4j.connector.Connection;
import org.shredzone.acme4j.connector.Resource;
import org.shredzone.acme4j.exception.AcmeException;
import org.shredzone.acme4j.exception.AcmeLazyLoadingException;
import org.shredzone.acme4j.exception.AcmeNotSupportedException;
import org.shredzone.acme4j.exception.AcmeProtocolException;
import org.shredzone.acme4j.toolbox.AcmeUtils;
import org.shredzone.acme4j.toolbox.JSONBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Certificate
extends AcmeResource {
    private static final long serialVersionUID = 7381527770159084201L;
    private static final Logger LOG = LoggerFactory.getLogger(Certificate.class);
    @Nullable
    private List<X509Certificate> certChain;
    @Nullable
    private Collection<URL> alternates;
    @Nullable
    private transient RenewalInfo renewalInfo = null;
    @Nullable
    private transient List<Certificate> alternateCerts = null;

    protected Certificate(Login login, URL certUrl) {
        super(login, certUrl);
    }

    public void download() throws AcmeException {
        if (this.certChain == null) {
            LOG.debug("download");
            try (Connection conn = this.getSession().connect();){
                conn.sendCertificateRequest(this.getLocation(), this.getLogin());
                this.alternates = conn.getLinks("alternate");
                this.certChain = conn.readCertificates();
            }
        }
    }

    public X509Certificate getCertificate() {
        this.lazyDownload();
        return Objects.requireNonNull(this.certChain).get(0);
    }

    public List<X509Certificate> getCertificateChain() {
        this.lazyDownload();
        return Collections.unmodifiableList(Objects.requireNonNull(this.certChain));
    }

    public List<URL> getAlternates() {
        this.lazyDownload();
        return Objects.requireNonNull(this.alternates).stream().collect(Collectors.toUnmodifiableList());
    }

    public List<Certificate> getAlternateCertificates() {
        if (this.alternateCerts == null) {
            Login login = this.getLogin();
            this.alternateCerts = this.getAlternates().stream().map(login::bindCertificate).collect(Collectors.toUnmodifiableList());
        }
        return this.alternateCerts;
    }

    public boolean isIssuedBy(String issuer) {
        String issuerCn = "CN=" + issuer;
        return this.getCertificateChain().stream().map(X509Certificate::getIssuerX500Principal).map(Principal::getName).anyMatch(issuerCn::equals);
    }

    public Optional<Certificate> findCertificate(String issuer) {
        if (this.isIssuedBy(issuer)) {
            return Optional.of(this);
        }
        return this.getAlternateCertificates().stream().filter(c -> c.isIssuedBy(issuer)).findFirst();
    }

    public void writeCertificate(Writer out) throws IOException {
        try {
            for (X509Certificate cert : this.getCertificateChain()) {
                AcmeUtils.writeToPem(cert.getEncoded(), AcmeUtils.PemLabel.CERTIFICATE, out);
            }
        }
        catch (CertificateEncodingException ex) {
            throw new IOException("Encoding error", ex);
        }
    }

    @Deprecated
    public String getCertID() {
        List<X509Certificate> certChain = this.getCertificateChain();
        if (certChain.size() < 2) {
            throw new AcmeProtocolException("Certificate has no issuer");
        }
        try {
            JcaDigestCalculatorProviderBuilder builder = new JcaDigestCalculatorProviderBuilder();
            if (Security.getProvider("BC") != null) {
                builder.setProvider("BC");
            }
            DigestCalculator digestCalc = builder.build().get(new AlgorithmIdentifier(NISTObjectIdentifiers.id_sha256));
            X509CertificateHolder issuerHolder = new X509CertificateHolder(certChain.get(1).getEncoded());
            CertificateID certId = new CertificateID(digestCalc, issuerHolder, certChain.get(0).getSerialNumber());
            return AcmeUtils.base64UrlEncode(certId.toASN1Primitive().getEncoded());
        }
        catch (Exception ex) {
            throw new AcmeProtocolException("Could not compute Certificate ID", ex);
        }
    }

    public Optional<URL> getRenewalInfoLocation() {
        try {
            return this.getSession().resourceUrlOptional(Resource.RENEWAL_INFO).map(baseUrl -> {
                try {
                    Object url = baseUrl.toExternalForm();
                    if (!((String)url).endsWith("/")) {
                        url = (String)url + "/";
                    }
                    url = (String)url + AcmeUtils.getRenewalUniqueIdentifier(this.getCertificate());
                    return new URL((String)url);
                }
                catch (MalformedURLException ex) {
                    throw new AcmeProtocolException("Invalid RenewalInfo URL", ex);
                }
            });
        }
        catch (AcmeException ex) {
            throw new AcmeLazyLoadingException(this, ex);
        }
    }

    public boolean hasRenewalInfo() {
        return this.getRenewalInfoLocation().isPresent();
    }

    public RenewalInfo getRenewalInfo() {
        if (this.renewalInfo == null) {
            this.renewalInfo = this.getRenewalInfoLocation().map(this.getLogin()::bindRenewalInfo).orElseThrow(() -> new AcmeNotSupportedException("renewal-info"));
        }
        return this.renewalInfo;
    }

    public void revoke() throws AcmeException {
        this.revoke(null);
    }

    public void revoke(@Nullable RevocationReason reason) throws AcmeException {
        Certificate.revoke(this.getLogin(), this.getCertificate(), reason);
    }

    public static void revoke(Login login, X509Certificate cert, @Nullable RevocationReason reason) throws AcmeException {
        LOG.debug("revoke");
        Session session = login.getSession();
        URL resUrl = session.resourceUrl(Resource.REVOKE_CERT);
        try (Connection conn = session.connect();){
            JSONBuilder claims = new JSONBuilder();
            claims.putBase64("certificate", cert.getEncoded());
            if (reason != null) {
                claims.put("reason", reason.getReasonCode());
            }
            conn.sendSignedRequest(resUrl, claims, login);
        }
        catch (CertificateEncodingException ex) {
            throw new AcmeProtocolException("Invalid certificate", ex);
        }
    }

    public static void revoke(Session session, KeyPair domainKeyPair, X509Certificate cert, @Nullable RevocationReason reason) throws AcmeException {
        LOG.debug("revoke using the domain key pair");
        URL resUrl = session.resourceUrl(Resource.REVOKE_CERT);
        try (Connection conn = session.connect();){
            JSONBuilder claims = new JSONBuilder();
            claims.putBase64("certificate", cert.getEncoded());
            if (reason != null) {
                claims.put("reason", reason.getReasonCode());
            }
            conn.sendSignedRequest(resUrl, claims, session, domainKeyPair);
        }
        catch (CertificateEncodingException ex) {
            throw new AcmeProtocolException("Invalid certificate", ex);
        }
    }

    private void lazyDownload() {
        try {
            this.download();
        }
        catch (AcmeException ex) {
            throw new AcmeLazyLoadingException(this, ex);
        }
    }
}

